/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.postagger;

import com.googlecode.clearnlp.component.AbstractComponent;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.engine.EngineGetter;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@TypeCapability(inputs={"org.apache.ctakes.typesystem.type.syntax.BaseToken:partOfSpeech", "org.apache.ctakes.typesystem.type.syntax.BaseToken:normalizedForm", "org.apache.ctakes.typesystem.type.syntax.BaseToken:tokenNumber", "org.apache.ctakes.typesystem.type.syntax.BaseToken:end", "org.apache.ctakes.typesystem.type.syntax.BaseToken:begin"})
@PipeBitInfo(name="ClearNLP POS Tagger", description="Adds Parts of Speech to Annotations.", role=PipeBitInfo.Role.ANNOTATOR, dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.BASE_TOKEN})
public class ClearNLPPOSTaggerAE
extends JCasAnnotator_ImplBase {
    final String language = "en";
    public Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    public static final String DEFAULT_MODEL_FILE_NAME = "org/apache/ctakes/postagger/models/clearnlp/mayo-en-pos-1.3.0.jar";
    public static final String PARAM_POS_MODEL_FILE_NAME = "POSModelFileName";
    @ConfigurationParameter(name="POSModelFileName", description="This parameter provides the file name of the Clear POS model required by the factory method provided by ClearNLPUtil.  If not specified, this analysis engine will use a default model from the resources directory")
    protected URI posModelUri;
    protected AbstractComponent postagger;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            URL parserModelURL = this.posModelUri == null ? ((Object)((Object)this)).getClass().getClassLoader().getResource(DEFAULT_MODEL_FILE_NAME).toURI().toURL() : this.posModelUri.toURL();
            this.postagger = EngineGetter.getComponent((InputStream)parserModelURL.openStream(), (String)this.language, (String)"pos");
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            DEPNode node;
            BaseToken token;
            int i;
            List tokens = JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)sentence);
            DEPTree tree = new DEPTree();
            for (i = 0; i < tokens.size(); ++i) {
                token = (BaseToken)tokens.get(i);
                node = new DEPNode(i + 1, token.getCoveredText());
                tree.add((Object)node);
            }
            this.postagger.process(tree);
            for (i = 0; i < tokens.size(); ++i) {
                token = (BaseToken)tokens.get(i);
                node = tree.get(i + 1);
                token.setPartOfSpeech(node.pos);
            }
        }
    }
}

