/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.util.StringTokenizer;
import java.util.Vector;

public class ToTokenize
extends Transformation
implements Cloneable {
    private static final String INFO = "Tokenize";

    public static Vector<LexItem> Mutate(LexItem in, boolean detailsFlag, boolean mutateFlag) {
        Vector<String> termList = ToTokenize.GetToken(in.GetSourceTerm());
        Vector<LexItem> out = new Vector<LexItem>();
        for (int i = 0; i < termList.size(); ++i) {
            String details = null;
            String mutate = null;
            if (detailsFlag) {
                details = INFO;
            }
            if (mutateFlag) {
                mutate = Transformation.NO_MUTATE_INFO;
            }
            String term = termList.elementAt(i);
            LexItem temp = ToTokenize.UpdateLexItem(in, term, 21, 2047L, 0xFFFFFFL, details, mutate);
            out.addElement(temp);
        }
        return out;
    }

    public static void main(String[] args) {
        String testStr = ToTokenize.GetTestStr(args, "The Club-Foot");
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = ToTokenize.Mutate(in, true, true);
        ToTokenize.PrintResults(in, outs);
    }

    private static Vector<String> GetToken(String inStr) {
        String delim = " \t-({[)}]_!@#%&*\\:;\"',.?/~+=|<>$`^";
        StringTokenizer buf = new StringTokenizer(inStr, delim);
        Vector<String> out = new Vector<String>();
        while (buf.hasMoreTokens()) {
            out.addElement(buf.nextToken());
        }
        return out;
    }
}

