/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbAcronym;
import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToStripPunctuation;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToFilterAcronym
extends Transformation
implements Cloneable {
    private static final String INFO = "Filter Out Acronyms";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, boolean detailsFlag, boolean mutateFlag) {
        boolean isAcronym = ToFilterAcronym.IsAcronym(in.GetSourceTerm(), conn);
        Vector<LexItem> out = new Vector<LexItem>();
        if (!isAcronym) {
            String term = in.GetSourceTerm();
            String details = null;
            String mutate = null;
            if (detailsFlag) {
                details = INFO;
            }
            if (mutateFlag) {
                mutate = Transformation.NO_MUTATE_INFO;
            }
            LexItem temp = ToFilterAcronym.UpdateLexItem(in, term, 31, 2047L, 0xFFFFFFL, details, mutate);
            out.addElement(temp);
        }
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToFilterAcronym.GetTestStr(args, "AIDS");
        LexItem in = new LexItem(testStr, 2047L, 0xFFFFFFL);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                outs = ToFilterAcronym.Mutate(in, conn, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToFilterAcronym.PrintResults(in, outs);
    }

    private static boolean IsAcronym(String inStr, Connection conn) {
        String strippedStr = ToStripPunctuation.StripPunctuation(inStr);
        String lcStrippedStr = strippedStr.toLowerCase();
        boolean isAcronym = false;
        try {
            isAcronym = DbAcronym.IsAcronym(lcStrippedStr, conn);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return isAcronym;
    }
}

