/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Db.CatInflBeginComparator;
import gov.nih.nlm.nls.lvg.Db.CatInflComparator;
import gov.nih.nlm.nls.lvg.Db.DbInflectionUtil;
import gov.nih.nlm.nls.lvg.Db.InflectionComparator;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Util.Bit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Vector;

public class DbInflection {
    public static long GetInflByCat(String inStr, int cat, Connection conn) throws SQLException {
        Vector<InflectionRecord> out = DbInflectionUtil.GetRecordsByIfTermCat(inStr, cat, conn);
        long infl = 0L;
        for (int i = 0; i < out.size(); ++i) {
            InflectionRecord record = out.elementAt(i);
            infl = Bit.Add(infl, record.GetInflection());
        }
        return infl;
    }

    public static Vector<InflectionRecord> GetCatInflBegin(String inStr, Connection conn) throws SQLException {
        Vector<InflectionRecord> out = DbInflectionUtil.GetRecordsBeginWithIfTerm(inStr, conn, false);
        CatInflBeginComparator cibc = new CatInflBeginComparator();
        Collections.sort(out, cibc);
        return out;
    }

    public static Vector<InflectionRecord> GetCatInfl(String inStr, Connection conn) throws SQLException {
        Vector<InflectionRecord> out = DbInflectionUtil.GetRecordsByIfTerm(inStr, conn, false);
        CatInflComparator cic = new CatInflComparator();
        Collections.sort(out, cic);
        return out;
    }

    public static Vector<InflectionRecord> GetInflections(String inStr, long inCat, long inInfl, Connection conn) throws SQLException {
        Vector<InflectionRecord> out = new Vector<InflectionRecord>();
        Vector<InflectionRecord> list = DbInflectionUtil.GetRecordsByIfTerm(inStr, conn, false);
        Vector<String> euiList = new Vector<String>();
        for (int i = 0; i < list.size(); ++i) {
            InflectionRecord record = list.elementAt(i);
            long curCat = record.GetCategory();
            long curInfl = record.GetInflection();
            if (!Bit.Contain(inCat, curCat) || !Bit.Contain(inInfl, curInfl) || euiList.contains(record.GetEui())) continue;
            Vector<InflectionRecord> records = DbInflection.GetInflections(record.GetEui(), record.GetUninflectedTerm(), -1, -1L, conn, false);
            out.addAll(records);
            euiList.add(record.GetEui());
        }
        InflectionComparator ic = new InflectionComparator();
        Collections.sort(out, ic);
        return out;
    }

    public static boolean IsExistInflectedTerm(String ifTerm, Connection conn) throws SQLException {
        if (ifTerm == null) {
            return false;
        }
        boolean existInTable = false;
        String query = "SELECT ifTermLC FROM Inflection WHERE ifTermLC = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setString(1, ifTerm.toLowerCase());
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            existInTable = true;
        }
        rs.close();
        ps.close();
        return existInTable;
    }

    private static Vector<InflectionRecord> GetInflections(String eui, String unTerm, int cat, long infl, Connection conn, boolean isUniqueEui) throws SQLException {
        PreparedStatement ps = null;
        String query = "SELECT ifTerm, termCat, termInfl, eui, unTerm, ctTerm FROM Inflection WHERE eui= ? AND unTermLC = ?";
        if (cat >= 0 && infl >= 0L) {
            query = query + " AND termCat = ? AND termInfl = ?";
            ps = conn.prepareStatement(query);
            ps.setString(1, eui);
            ps.setString(2, unTerm.toLowerCase());
            ps.setInt(3, cat);
            ps.setLong(4, infl);
        } else if (cat >= 0) {
            query = query + " AND termCat = ?";
            ps = conn.prepareStatement(query);
            ps.setString(1, eui);
            ps.setString(2, unTerm.toLowerCase());
            ps.setInt(3, cat);
        } else if (infl >= 0L) {
            query = query + " AND termInfl = ?";
            ps = conn.prepareStatement(query);
            ps.setString(1, eui);
            ps.setString(2, unTerm.toLowerCase());
            ps.setLong(3, infl);
        } else {
            ps = conn.prepareStatement(query);
            ps.setString(1, eui);
            ps.setString(2, unTerm.toLowerCase());
        }
        return DbInflectionUtil.GetRecordsByPreparedStatement(ps, isUniqueEui);
    }
}

