/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.evaluator;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.kernel.evaluator.CacheKernel;
import org.apache.ctakes.ytex.kernel.evaluator.Kernel;

public class ProductKernel
extends CacheKernel {
    private static final Log log = LogFactory.getLog(ProductKernel.class);
    Kernel[] delegateKernels;

    public List<Kernel> getDelegateKernels() {
        return Arrays.asList(this.delegateKernels);
    }

    public void setDelegateKernels(List<Kernel> delegateKernels) {
        this.delegateKernels = new Kernel[delegateKernels.size()];
        for (int i = 0; i < this.delegateKernels.length; ++i) {
            this.delegateKernels[i] = delegateKernels.get(i);
        }
    }

    @Override
    public double innerEvaluate(Object o1, Object o2) {
        double d = 1.0;
        for (Kernel k : this.delegateKernels) {
            if ((d *= k.evaluate(o1, o2)) == 0.0) break;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)new StringBuilder("K<").append(o1).append(",").append(o2).append("> = ").append(d));
        }
        return d;
    }
}

