/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.jdl.common;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.SystemUtils;

public final class FileUtil {
    private FileUtil() {
    }

    public static String[] getJavaClassPaths() {
        return SystemUtils.JAVA_CLASS_PATH.split(SystemUtils.PATH_SEPARATOR);
    }

    public static File getFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            return file;
        }
        for (String token : FileUtil.getJavaClassPaths()) {
            file = new File(token + SystemUtils.FILE_SEPARATOR + fileName);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public static String getCanonical(File file, String defaultString) {
        try {
            return file == null ? defaultString : file.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return defaultString;
        }
    }

    public static String getCanonical(File file) {
        return FileUtil.getCanonical(file, SystemUtils.USER_DIR);
    }

    public static String fullPath(File filePath, String fileName) {
        return FileUtil.getCanonical(filePath) + SystemUtils.FILE_SEPARATOR + fileName;
    }
}

