/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.dependency;

public class DEPLabel {
    static final String DELIM = "_";
    public String arc;
    public String list;
    public String deprel;
    public double score;

    public DEPLabel() {
    }

    public DEPLabel(String label, double score) {
        this.set(label);
        this.score = score;
    }

    public DEPLabel(String label) {
        this.set(label);
    }

    public DEPLabel(String arc, String deprel) {
        this.arc = arc;
        this.list = "";
        this.deprel = deprel;
    }

    public void set(String label) {
        int idx = label.indexOf(DELIM);
        this.arc = label.substring(0, idx);
        int n = idx + 1;
        idx = label.lastIndexOf(DELIM);
        this.list = label.substring(n, idx);
        this.deprel = label.substring(idx + 1);
    }

    public boolean isArc(String label) {
        return this.arc.equals(label);
    }

    public boolean isList(String label) {
        return this.list.equals(label);
    }

    public boolean isDeprel(String label) {
        return this.deprel.equals(label);
    }

    public boolean isSame(DEPLabel label) {
        return this.isArc(label.arc) && this.isList(label.list) && this.isDeprel(label.deprel);
    }

    public String toString() {
        StringBuilder build = new StringBuilder();
        build.append(this.arc);
        build.append(DELIM);
        build.append(this.list);
        build.append(DELIM);
        build.append(this.deprel);
        return build.toString();
    }
}

