/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.pipelines;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.ctakes.relationextractor.eval.XMIReader;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class RelationAnnotationViewer {
    public static void main(String[] args) throws Exception {
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser((Object)options);
        parser.parseArgument(args);
        List<File> trainFiles = Arrays.asList(options.inputDirectory.listFiles());
        CollectionReader collectionReader = RelationAnnotationViewer.getCollectionReader(trainFiles);
        AnalysisEngine relationExtractorPrinter = AnalysisEngineFactory.createEngine(RelationExtractorPrinter.class, (Object[])new Object[0]);
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{relationExtractorPrinter});
    }

    private static CollectionReader getCollectionReader(List<File> items) throws Exception {
        String[] paths = new String[items.size()];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = items.get(i).getPath();
        }
        return CollectionReaderFactory.createReader(XMIReader.class, (Object[])new Object[]{"files", paths});
    }

    public static class RelationExtractorPrinter
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas systemView;
            try {
                systemView = jCas.getView("_InitialView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            for (BinaryTextRelation binaryTextRelation : JCasUtil.select((JCas)systemView, BinaryTextRelation.class)) {
                IdentifiedAnnotation entity1 = (IdentifiedAnnotation)binaryTextRelation.getArg1().getArgument();
                IdentifiedAnnotation entity2 = (IdentifiedAnnotation)binaryTextRelation.getArg2().getArgument();
                String category = binaryTextRelation.getCategory();
                String arg1 = entity1.getCoveredText().toLowerCase();
                String arg2 = entity2.getCoveredText().toLowerCase();
                List enclosingSentences = JCasUtil.selectCovering((JCas)systemView, Sentence.class, (int)entity1.getBegin(), (int)entity2.getEnd());
                System.out.format("%s|%s|%s|%s\n", category, arg1, arg2, ((Sentence)enclosingSentences.get(0)).getCoveredText());
            }
        }
    }

    public static class Options {
        @Option(name="--input-dir", usage="specify the path to the directory containing the clinical notes to be processed", required=true)
        public File inputDirectory;
    }
}

