/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.ae;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.relationextractor.ae.RelationExtractorAnnotator;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.DegreeOfTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Modifier;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

@PipeBitInfo(name="Degree of Annotator", description="Annotates Degree Of relations.", role=PipeBitInfo.Role.ANNOTATOR, dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION}, products={PipeBitInfo.TypeProduct.DEGREE_RELATION})
public class DegreeOfRelationExtractorAnnotator
extends RelationExtractorAnnotator {
    @Override
    protected Class<? extends BinaryTextRelation> getRelationClass() {
        return DegreeOfTextRelation.class;
    }

    public List<RelationExtractorAnnotator.IdentifiedAnnotationPair> getCandidateRelationArgumentPairs(JCas identifiedAnnotationView, Annotation sentence) {
        List events = JCasUtil.selectCovered((JCas)identifiedAnnotationView, EventMention.class, (AnnotationFS)sentence);
        List modifiers = JCasUtil.selectCovered((JCas)identifiedAnnotationView, Modifier.class, (AnnotationFS)sentence);
        ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair> pairs = new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
        for (EventMention event : events) {
            for (Modifier modifier : modifiers) {
                pairs.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)event, (IdentifiedAnnotation)modifier));
            }
        }
        return pairs;
    }

    @Override
    protected void createRelation(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2, String predictedCategory) {
        RelationArgument relArg1 = new RelationArgument(jCas);
        relArg1.setArgument((Annotation)arg1);
        relArg1.setRole("Argument");
        relArg1.addToIndexes();
        RelationArgument relArg2 = new RelationArgument(jCas);
        relArg2.setArgument((Annotation)arg2);
        relArg2.setRole("Related_to");
        relArg2.addToIndexes();
        DegreeOfTextRelation relation = new DegreeOfTextRelation(jCas);
        relation.setArg1(relArg1);
        relation.setArg2(relArg2);
        relation.setCategory(predictedCategory);
        relation.addToIndexes();
    }

    @Override
    protected Class<? extends Annotation> getCoveringClass() {
        return Sentence.class;
    }
}

