/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat;

import org.apache.commons.cli.Options;
import org.apache.rat.OptionCollection;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.Reporter;
import org.apache.rat.VersionInfo;
import org.apache.rat.document.RatDocumentAnalysisException;
import org.apache.rat.help.Help;
import org.apache.rat.utils.DefaultLog;

public final class Report {
    public static void main(String[] args) throws Exception {
        DefaultLog.getInstance().info(new VersionInfo().toString());
        ReportConfiguration configuration = OptionCollection.parseCommands(args, Report::printUsage);
        if (configuration != null) {
            configuration.validate(DefaultLog.getInstance()::error);
            Reporter reporter = new Reporter(configuration);
            reporter.output();
            reporter.writeSummary(DefaultLog.getInstance().asWriter());
            if (configuration.getClaimValidator().hasErrors()) {
                configuration.getClaimValidator().logIssues(reporter.getClaimsStatistic());
                throw new RatDocumentAnalysisException(String.format("Issues with %s", String.join((CharSequence)", ", configuration.getClaimValidator().listIssues(reporter.getClaimsStatistic()))));
            }
        }
    }

    private static void printUsage(Options opts) {
        new Help(System.out).printUsage(opts);
    }

    private Report() {
    }
}

