/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.OptionCollection;
import org.apache.rat.documentation.options.AbstractOption;
import org.apache.rat.documentation.options.AntOption;
import org.apache.rat.utils.DefaultLog;

public final class AntDocumentation {
    private final File outputDir;

    public static void main(String[] args) {
        File outputDir;
        if (args.length == 0) {
            System.err.println("Output directory must be specified");
            System.exit(1);
        }
        if ((outputDir = new File(args[0])).exists()) {
            if (!outputDir.isDirectory()) {
                DefaultLog.getInstance().error(String.format("%s is not a directory", args[0]));
                System.exit(1);
            }
        } else if (!outputDir.mkdirs()) {
            DefaultLog.getInstance().error(String.format("Can not create directory %s", args[0]));
            System.exit(1);
        }
        new AntDocumentation(outputDir).execute();
    }

    private AntDocumentation(File outputDir) {
        this.outputDir = outputDir;
    }

    public void execute() {
        List<AntOption> options = AntOption.getAntOptions();
        this.writeAttributes(options);
        this.writeElements(options);
        this.printValueTypes();
    }

    public void writeAttributes(List<AntOption> options) {
        File f = new File(this.outputDir, "report_attributes.txt");
        try (OutputStreamWriter out = new OutputStreamWriter(Files.newOutputStream(f.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            this.printOptions(out, options, AntOption::isAttribute, "The attribute value types are listed in a table at the bottom of this page.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeElements(List<AntOption> options) {
        File f = new File(this.outputDir, "report_elements.txt");
        try (OutputStreamWriter out = new OutputStreamWriter(Files.newOutputStream(f.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            this.printOptions(out, options, AntOption::isElement, "The element value types are listed in a table at the bottom of this page.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void printOptions(Writer out, List<AntOption> options, Predicate<AntOption> typeFilter, String tableCaption) throws IOException {
        boolean hasDeprecated = options.stream().anyMatch(typeFilter.and(AbstractOption::isDeprecated));
        if (hasDeprecated) {
            AptFormat.writeHeader(out, 2, "Current");
        }
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        table.add(Arrays.asList("Name", "Description", "Value Type", "Required"));
        options.stream().filter(typeFilter.and(o -> !o.isDeprecated())).map(o -> Arrays.asList(o.getName(), o.getDescription(), o.hasArg() ? StringUtils.defaultIfEmpty(o.getArgName(), "String") : "boolean", o.isRequired() ? "true" : "false")).forEach(table::add);
        AptFormat.writeTable(out, table, "*--+--+--+--+", tableCaption);
        if (hasDeprecated) {
            AptFormat.writeHeader(out, 2, "Deprecated ");
            table.clear();
            table.add(Arrays.asList("Name", "Description", "Argument Type", "Deprecated"));
            options.stream().filter(typeFilter.and(AbstractOption::isDeprecated)).map(o -> Arrays.asList(o.getName(), o.getDescription(), o.hasArg() ? StringUtils.defaultIfEmpty(o.getArgName(), "String") : "boolean", o.getDeprecated())).forEach(table::add);
            AptFormat.writeTable(out, table, "*--+--+--+--+", tableCaption);
        }
    }

    private void printValueTypes() {
        File f = new File(this.outputDir, "report_arg_types.txt");
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(f.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            ArrayList<List<String>> table = new ArrayList<List<String>>();
            table.add(Arrays.asList("Value Type", "Description"));
            for (Map.Entry<String, Supplier<String>> argInfo : OptionCollection.getArgumentTypes().entrySet()) {
                table.add(Arrays.asList(argInfo.getKey(), argInfo.getValue().get()));
            }
            AptFormat.writeTable(writer, table, "*--+--+");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class AptFormat {
        private AptFormat() {
        }

        public static void writeLicense(Writer writer) throws IOException {
            try (InputStream in = AntDocumentation.class.getResourceAsStream("/license.apt");){
                if (in == null) {
                    throw new FileNotFoundException("Could not find license.apt");
                }
                IOUtils.copy(in, writer, StandardCharsets.UTF_8);
            }
        }

        public static void writeTitle(Writer writer, String title) throws IOException {
            writer.write(String.format("        -----%n        %1$s%n        -----%n%n%1$s%n%n", title));
        }

        public static void writePara(Writer writer, String paragraph) throws IOException {
            writer.write(String.format("  %s%n%n", paragraph));
        }

        public static void writeHeader(Writer writer, int level, String text) throws IOException {
            writer.write(System.lineSeparator());
            for (int i = 0; i < level; ++i) {
                writer.write("*");
            }
            writer.write(String.format(" %s%n%n", text));
        }

        public static void writeList(Writer writer, Collection<String> list) throws IOException {
            for (String s : list) {
                writer.write(String.format("    * %s%n", s));
            }
            writer.write(System.lineSeparator());
        }

        public static void writeTable(Writer writer, Collection<? extends Collection<String>> table, String pattern, String caption) throws IOException {
            writer.write(String.format("%s%n", pattern));
            for (Collection<String> collection : table) {
                for (String cell : collection) {
                    writer.write(String.format("| %s ", cell));
                }
                writer.write(String.format("|%n%s%n", pattern));
            }
            if (caption != null) {
                writer.write(caption);
            }
            writer.write(System.lineSeparator());
        }

        public static void writeTable(Writer writer, Collection<? extends Collection<String>> table, String pattern) throws IOException {
            AptFormat.writeTable(writer, table, pattern, null);
        }
    }
}

