/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import org.apache.commons.numbers.core.Sum;
import org.apache.commons.statistics.descriptive.FirstMoment;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;
import org.apache.commons.statistics.descriptive.StatisticResult;
import org.apache.commons.statistics.descriptive.SumOfCubedDeviations;
import org.apache.commons.statistics.descriptive.SumOfFourthDeviations;
import org.apache.commons.statistics.descriptive.SumOfSquaredDeviations;

final class Statistics {
    static final DoubleConsumer DOUBLE_NOOP = new DoubleConsumer(){

        @Override
        public void accept(double value) {
        }

        @Override
        public DoubleConsumer andThen(DoubleConsumer after) {
            return after;
        }
    };
    static final IntConsumer INT_NOOP = new IntConsumer(){

        @Override
        public void accept(int value) {
        }

        @Override
        public IntConsumer andThen(IntConsumer after) {
            return after;
        }
    };
    static final LongConsumer LONG_NOOP = new LongConsumer(){

        @Override
        public void accept(long value) {
        }

        @Override
        public LongConsumer andThen(LongConsumer after) {
            return after;
        }
    };
    private static final String INCOMPATIBLE_STATISTICS = "Incompatible statistics";

    private Statistics() {
    }

    static <T extends DoubleConsumer> T add(T statistic, double[] values) {
        for (double x : values) {
            statistic.accept(x);
        }
        return statistic;
    }

    static <T extends DoubleConsumer> T add(T statistic, double[] values, int from, int to) {
        for (int i = from; i < to; ++i) {
            statistic.accept(values[i]);
        }
        return statistic;
    }

    static <T extends DoubleConsumer> T add(T statistic, int[] values) {
        int[] nArray = values;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            double x = nArray[i];
            statistic.accept(x);
        }
        return statistic;
    }

    static <T extends DoubleConsumer> T add(T statistic, int[] values, int from, int to) {
        for (int i = from; i < to; ++i) {
            statistic.accept(values[i]);
        }
        return statistic;
    }

    static <T extends DoubleConsumer> T add(T statistic, long[] values) {
        long[] lArray = values;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            double x = lArray[i];
            statistic.accept(x);
        }
        return statistic;
    }

    static <T extends DoubleConsumer> T add(T statistic, long[] values, int from, int to) {
        for (int i = from; i < to; ++i) {
            statistic.accept(values[i]);
        }
        return statistic;
    }

    static <T extends IntConsumer> T add(T statistic, int[] values) {
        for (int x : values) {
            statistic.accept(x);
        }
        return statistic;
    }

    static <T extends IntConsumer> T add(T statistic, int[] values, int from, int to) {
        for (int i = from; i < to; ++i) {
            statistic.accept(values[i]);
        }
        return statistic;
    }

    static <T extends LongConsumer> T add(T statistic, long[] values) {
        for (long x : values) {
            statistic.accept(x);
        }
        return statistic;
    }

    static <T extends LongConsumer> T add(T statistic, long[] values, int from, int to) {
        for (int i = from; i < to; ++i) {
            statistic.accept(values[i]);
        }
        return statistic;
    }

    static boolean zeroVariance(double m1, double m2) {
        double meanPrecision = 1.0E-15 * m1;
        return m2 <= meanPrecision * meanPrecision;
    }

    static DoubleConsumer composeDoubleConsumers(DoubleConsumer ... consumers) {
        DoubleConsumer action = DOUBLE_NOOP;
        for (DoubleConsumer consumer : consumers) {
            if (consumer == null) continue;
            action = action.andThen(consumer);
        }
        return action == DOUBLE_NOOP ? null : action;
    }

    static IntConsumer composeIntConsumers(IntConsumer ... consumers) {
        IntConsumer action = INT_NOOP;
        for (IntConsumer consumer : consumers) {
            if (consumer == null) continue;
            action = action.andThen(consumer);
        }
        return action == INT_NOOP ? null : action;
    }

    static LongConsumer composeLongConsumers(LongConsumer ... consumers) {
        LongConsumer action = LONG_NOOP;
        for (LongConsumer consumer : consumers) {
            if (consumer == null) continue;
            action = action.andThen(consumer);
        }
        return action == LONG_NOOP ? null : action;
    }

    static StatisticResult getResultAsIntOrNull(StatisticResult s) {
        if (s != null) {
            return s::getAsInt;
        }
        return null;
    }

    static StatisticResult getResultAsLongOrNull(StatisticResult s) {
        if (s != null) {
            return s::getAsLong;
        }
        return null;
    }

    static StatisticResult getResultAsDoubleOrNull(StatisticResult s) {
        if (s != null) {
            return s::getAsDouble;
        }
        return null;
    }

    static StatisticResult getResultAsBigIntegerOrNull(StatisticResult s) {
        if (s != null) {
            return s::getAsBigInteger;
        }
        return null;
    }

    static <T extends StatisticResult & StatisticAccumulator<T>> void checkCombineCompatible(T a, T b) {
        if (a != null && b == null) {
            throw new IllegalArgumentException(INCOMPATIBLE_STATISTICS);
        }
    }

    static void checkCombineAssignable(FirstMoment a, FirstMoment b) {
        if (!(a == null || b != null && a.getClass().isAssignableFrom(b.getClass()))) {
            throw new IllegalArgumentException(INCOMPATIBLE_STATISTICS);
        }
    }

    static <T extends StatisticResult & StatisticAccumulator<T>> void combine(T a, T b) {
        if (a != null) {
            ((StatisticAccumulator<T>)a).combine(b);
        }
    }

    static void combineMoment(FirstMoment a, FirstMoment b) {
        if (a instanceof SumOfFourthDeviations) {
            ((SumOfFourthDeviations)a).combine((SumOfFourthDeviations)b);
        } else if (a instanceof SumOfCubedDeviations) {
            ((SumOfCubedDeviations)a).combine((SumOfCubedDeviations)b);
        } else if (a instanceof SumOfSquaredDeviations) {
            ((SumOfSquaredDeviations)a).combine((SumOfSquaredDeviations)b);
        } else if (a != null) {
            a.combine(b);
        }
    }

    static void checkFromToIndex(int fromIndex, int toIndex, int length) {
        if (fromIndex < 0 || fromIndex > toIndex || toIndex > length) {
            throw new IndexOutOfBoundsException(Statistics.msgRangeOutOfBounds(fromIndex, toIndex, length));
        }
    }

    private static String msgRangeOutOfBounds(int fromIndex, int toIndex, int length) {
        return String.format("Range [%d, %d) out of bounds for length %d", fromIndex, toIndex, length);
    }

    static Sum sum(double[] values, int from, int to) {
        Sum s = Sum.create();
        for (int i = from; i < to; ++i) {
            s.accept(values[i]);
        }
        return s;
    }

    static int[] copy(int[] data, int from, int to) {
        int length = to - from;
        int[] copy = new int[length];
        System.arraycopy(data, from, copy, 0, length);
        return copy;
    }
}

