/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.ObjectContext;
import org.apache.commons.jexl3.internal.TemplateDebugger;
import org.apache.commons.jexl3.introspection.JexlSandbox;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Issues200Test
extends JexlTestCase {
    public Issues200Test() {
        super("Issues200Test", null);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        Logger.getLogger(JexlEngine.class.getName()).setLevel(Level.SEVERE);
    }

    @Test
    public void test200() throws Exception {
        MapContext jc = new MapContext();
        HashMap<Object, Eval> funcs = new HashMap<Object, Eval>();
        Eval eval = new Eval();
        funcs.put(null, eval);
        JexlEngine jexl = new JexlBuilder().namespaces(funcs).create();
        eval.setJexl(jexl);
        String src = "var f = fn('(x)->{x + 42}'); f(y)";
        JexlScript s200 = jexl.createScript("var f = fn('(x)->{x + 42}'); f(y)", new String[]{"y"});
        Assert.assertEquals((Object)142, (Object)s200.execute((JexlContext)jc, new Object[]{100}));
        Assert.assertEquals((Object)52, (Object)s200.execute((JexlContext)jc, new Object[]{10}));
    }

    @Test
    public void test200b() throws Exception {
        MapContext jc = new MapContext();
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript e = jexl.createScript("var x = 0; var f = (y)->{ x = y; }; f(42); x");
        Object r = e.execute((JexlContext)jc);
        Assert.assertEquals((Object)0, (Object)r);
    }

    @Test
    public void test209a() throws Exception {
        MapContext jc = new MapContext();
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript e = jexl.createScript("var x = new('java.util.HashMap'); x.a = ()->{return 1}; x['a']()");
        Object r = e.execute((JexlContext)jc);
        Assert.assertEquals((Object)1, (Object)r);
    }

    @Test
    public void test209b() throws Exception {
        MapContext jc = new MapContext();
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript e = jexl.createScript("var x = new('java.util.HashMap'); x['a'] = ()->{return 1}; x.a()");
        Object r = e.execute((JexlContext)jc);
        Assert.assertEquals((Object)1, (Object)r);
    }

    @Test
    public void test210() throws Exception {
        MapContext jc = new MapContext();
        jc.set("v210", (Object)new T210());
        JexlEngine jexl = new JexlBuilder().strict(false).silent(false).create();
        JexlScript e = jexl.createScript("v210.npe()");
        try {
            e.execute((JexlContext)jc);
            Assert.fail((String)"should have thrown an exception");
        }
        catch (JexlException xjexl) {
            Throwable th = xjexl.getCause();
            Assert.assertEquals((Object)"NPE210", (Object)th.getMessage());
        }
    }

    @Test
    public void test217() throws Exception {
        JexlEvalContext jc = new JexlEvalContext();
        JexlOptions options = jc.getEngineOptions();
        jc.set("foo", new int[]{0, 1, 2, 42});
        JexlEngine jexl = new JexlBuilder().strict(false).silent(false).create();
        JexlScript e = jexl.createScript("foo[3]");
        Object r = e.execute((JexlContext)jc);
        Assert.assertEquals((Object)42, (Object)r);
        jc.set("foo", new int[]{0, 1});
        options.setStrict(true);
        Assert.assertTrue((boolean)options.isStrict());
        try {
            r = e.execute((JexlContext)jc);
            Assert.fail((String)"should have thrown an exception");
        }
        catch (JexlException xjexl) {
            Throwable th = xjexl.getCause();
            Assert.assertEquals(ArrayIndexOutOfBoundsException.class, th.getClass());
        }
        options.setStrict(false);
        r = e.execute((JexlContext)jc);
        Assert.assertNull((String)"oob adverted", (Object)r);
    }

    @Test
    public void test221() throws Exception {
        JexlEvalContext jc = new JexlEvalContext();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("one", 1);
        jc.set("map", map);
        JexlEngine jexl = new JexlBuilder().cache(256).create();
        JexlScript e = jexl.createScript("(x)->{ map[x] }");
        Object r = e.execute((JexlContext)jc, new Object[]{null});
        Assert.assertNull((Object)r);
        r = e.execute((JexlContext)jc, new Object[]{null});
        Assert.assertNull((Object)r);
        r = e.execute((JexlContext)jc, new Object[]{"one"});
        Assert.assertEquals((Object)1, (Object)r);
    }

    @Test
    public void test224() throws Exception {
        List<String> a0 = Arrays.asList("one", "two");
        TreeSet<String> a1 = new TreeSet<String>(a0);
        MapContext jc = new MapContext();
        JexlEngine jexl = new JexlBuilder().arithmetic((JexlArithmetic)new JexlArithmetic224(true)).create();
        JexlScript e = jexl.createScript("(map, x)->{ map[x] }");
        Object r = e.execute((JexlContext)jc, new Object[]{a0, 1});
        Assert.assertEquals((Object)"two", (Object)r);
        r = e.execute((JexlContext)jc, new Object[]{a1, 1});
        Assert.assertEquals((Object)"two", (Object)r);
        e = jexl.createScript("(map)->{ map.1 }");
        r = e.execute((JexlContext)jc, new Object[]{a0});
        Assert.assertEquals((Object)"two", (Object)r);
        r = e.execute((JexlContext)jc, new Object[]{a1});
        Assert.assertEquals((Object)"two", (Object)r);
        e = jexl.createScript("(map, x)->{ map(x) }");
        r = e.execute((JexlContext)jc, new Object[]{a0, 1});
        Assert.assertEquals((Object)"two", (Object)r);
        r = e.execute((JexlContext)jc, new Object[]{a1, 1});
        Assert.assertEquals((Object)"two", (Object)r);
    }

    @Test
    public void test225() throws Exception {
        Context225 df = new Context225();
        JexlEngine jexl = new JexlBuilder().create();
        JexlExpression expression = jexl.createExpression("bar()");
        Assert.assertEquals((Object)"bar", (Object)expression.evaluate((JexlContext)df));
        ObjectContext context = new ObjectContext(jexl, (Object)df);
        Assert.assertEquals((Object)"bar", (Object)expression.evaluate((JexlContext)context));
    }

    private static void handle(ExecutorService pool, JexlScript script, Map<String, Object> payload) {
        pool.submit(() -> script.execute((JexlContext)new MapContext(payload)));
    }

    @Test
    public void test241() throws Exception {
        JexlScript script = new JexlBuilder().create().createScript("`${item}`");
        ExecutorService pool = Executors.newFixedThreadPool(4);
        HashMap<String, Object> m1 = new HashMap<String, Object>();
        m1.put("item", "A");
        HashMap<String, String> m2 = new HashMap<String, String>();
        m2.put("item", "B");
        Issues200Test.handle(pool, script, m1);
        script.execute((JexlContext)new MapContext(m2));
        pool.shutdown();
    }

    @Test
    public void test242() throws Exception {
        Double a = -40.05;
        Double b = -8.01;
        Double c = a + b;
        MapContext context = new MapContext();
        context.set("a", (Object)a);
        context.set("b", (Object)b);
        JexlEngine JEXL_ENGINE = new JexlBuilder().strict(true).silent(true).create();
        JexlExpression jsp = JEXL_ENGINE.createExpression("a + b");
        Double e = (Double)jsp.evaluate((JexlContext)context);
        Assert.assertEquals((String)(Double.doubleToLongBits(e) + " != " + Double.doubleToLongBits(c)), (double)c, (double)e, (double)0.0);
        Assert.assertEquals((String)(Double.doubleToLongBits(e) + " != " + Double.doubleToLongBits(c)), (double)(a + b), (double)e, (double)0.0);
    }

    @Test
    public void test243a() throws Exception {
        JexlEngine jexl = new JexlBuilder().cache(32).create();
        JexlScript script = jexl.createScript("while(true);");
        try {
            JexlExpression expr = jexl.createExpression("while(true);");
            Assert.fail((String)"should have failed!, expr do not allow 'while' statement");
        }
        catch (JexlException jexlException) {
            // empty catch block
        }
    }

    @Test
    public void test245() throws Exception {
        Object[] args;
        MapContext ctx = new MapContext();
        Foo245 foo245 = new Foo245();
        ctx.set("foo", (Object)foo245);
        JexlEngine engine = new JexlBuilder().strict(true).safe(false).silent(false).create();
        JexlExpression foobar = engine.createExpression("foo.bar");
        JexlExpression foobaz = engine.createExpression("foo.baz");
        JexlExpression foobarbaz = engine.createExpression("foo.bar.baz");
        for (Object arg : args = new Object[]{null, 245}) {
            foo245.setBar(arg);
            Assert.assertEquals((Object)foo245.getBar(), (Object)foobar.evaluate((JexlContext)ctx));
            try {
                foobaz.evaluate((JexlContext)ctx);
                Assert.fail((String)"foo.baz is not solvable, exception expected");
            }
            catch (JexlException xp) {
                Assert.assertTrue((boolean)(xp instanceof JexlException.Property));
            }
            try {
                foobarbaz.evaluate((JexlContext)ctx);
                Assert.fail((String)"foo.bar.baz is not solvable, exception expected");
            }
            catch (JexlException xp) {
                Assert.assertTrue((boolean)(xp instanceof JexlException.Property));
            }
        }
    }

    @Test
    public void test256() throws Exception {
        MapContext ctx = new MapContext(){

            public void set(String name, Object value) {
                if ("java".equals(name)) {
                    throw new JexlException(null, "can not set " + name);
                }
                super.set(name, value);
            }

            public Object get(String name) {
                if ("java".equals(name)) {
                    return null;
                }
                return super.get(name);
            }

            public boolean has(String name) {
                if ("java".equals(name)) {
                    return false;
                }
                return super.has(name);
            }
        };
        ctx.set("java.version", (Object)10);
        JexlEngine engine = new JexlBuilder().strict(true).silent(false).create();
        JexlScript script = engine.createScript("java = 3");
        try {
            script.execute((JexlContext)ctx);
            Assert.fail((String)"should have failed!");
        }
        catch (JexlException jexlException) {
            // empty catch block
        }
        script = engine.createScript("java.version");
        Assert.assertEquals((Object)10, (Object)script.execute((JexlContext)ctx));
    }

    @Test
    public void test230() throws Exception {
        JexlEngine jexl = new JexlBuilder().cache(4).create();
        MapContext ctxt = new MapContext();
        int[] foo = new int[]{42};
        ctxt.set("fo o", (Object)foo);
        for (int l = 0; l < 2; ++l) {
            Object value = jexl.createExpression("fo\\ o[0]").evaluate((JexlContext)ctxt);
            Assert.assertEquals((Object)42, (Object)value);
            value = jexl.createExpression("fo\\ o[0] = 43").evaluate((JexlContext)ctxt);
            Assert.assertEquals((Object)43, (Object)value);
            value = jexl.createExpression("fo\\ o.0").evaluate((JexlContext)ctxt);
            Assert.assertEquals((Object)43, (Object)value);
            value = jexl.createExpression("fo\\ o.0 = 42").evaluate((JexlContext)ctxt);
            Assert.assertEquals((Object)42, (Object)value);
        }
    }

    @Test
    public void test265() throws Exception {
        JexlScript script;
        JexlEngine jexl = new JexlBuilder().cache(4).create();
        MapContext ctxt = new MapContext();
        ctxt.set("x", (Object)42);
        try {
            script = jexl.createScript("(true) ? x : abs(1)");
        }
        catch (JexlException.Parsing parsing) {
            // empty catch block
        }
        script = jexl.createScript("(true) ? (x) : abs(2)");
        Object result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)42, (Object)result);
        script = jexl.createScript("(true) ? x : (abs(3))");
        result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)42, (Object)result);
        script = jexl.createScript("(!true) ? abs(4) : x");
        result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void test266() throws Exception {
        JexlEngine jexl = new JexlBuilder().arithmetic((JexlArithmetic)new Arithmetic266(true)).create();
        MapContext ctxt = new MapContext();
        ArrayList<Integer> li = new ArrayList<Integer>(Arrays.asList(1, 2, 3, 4, 5, 6));
        ctxt.set("list", li);
        JexlScript script = jexl.createScript("for (var item : list) { if (item <= 3) remove(); } return size(list)");
        Object result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)3, (Object)result);
        Assert.assertEquals((long)3L, (long)li.size());
        HashMap<String, Integer> msi = new HashMap<String, Integer>();
        msi.put("a", 1);
        msi.put("b", 2);
        msi.put("c", 3);
        msi.put("d", 4);
        msi.put("e", 5);
        msi.put("f", 6);
        ctxt.set("map", msi);
        script = jexl.createScript("for (var item : map) { if (item <= 2) remove(); } return size(map)");
        result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)4, (Object)result);
        Assert.assertEquals((long)4L, (long)msi.size());
    }

    @Test
    public void test267() throws Exception {
        JexlEngine jexl = new JexlBuilder().create();
        MapContext ctxt = new MapContext();
        JexlScript script = jexl.createScript("x + y", new String[]{"x", "y"});
        Object result = script.execute((JexlContext)ctxt, new Object[]{20, 22});
        Assert.assertEquals((Object)42, (Object)result);
        script = jexl.createScript("(x, y)->{ x + y}");
        result = script.execute((JexlContext)ctxt, new Object[]{22, 20});
        Assert.assertEquals((Object)42, (Object)result);
        script = jexl.createScript("return (x, y)->{ x + y}");
        result = script.execute((JexlContext)ctxt);
        Assert.assertTrue((boolean)(result instanceof JexlScript));
    }

    @Test
    public void test274() throws Exception {
        String sxs;
        JexlEngine jexl = new JexlBuilder().strict(true).safe(true).stackOverflow(5).create();
        MapContext ctxt = new MapContext();
        JexlScript script = jexl.createScript("var f = (x)->{ x > 1? x * f(x - 1) : x }; f(a)", new String[]{"a"});
        Object result = script.execute((JexlContext)ctxt, new Object[]{3});
        Assert.assertEquals((Object)6, (Object)result);
        try {
            result = script.execute((JexlContext)ctxt, new Object[]{32});
            Assert.fail((String)"should have overflown");
        }
        catch (JexlException.StackOverflow xstack) {
            sxs = xstack.toString();
            Assert.assertTrue((boolean)sxs.contains("jexl"));
        }
        jexl = new JexlBuilder().strict(true).create();
        script = jexl.createScript("var f = (x)->{ x * f(x - 1) }; f(a)", new String[]{"a"});
        try {
            result = script.execute((JexlContext)ctxt, new Object[]{32});
            Assert.fail((String)"should have overflown");
        }
        catch (JexlException.StackOverflow xstack) {
            sxs = xstack.toString();
            Assert.assertTrue((boolean)sxs.contains("jvm"));
        }
    }

    @Test
    public void test275a() throws Exception {
        MapContext ctxt = new MapContext();
        ctxt.set("out", (Object)System.out);
        JexlEngine jexl = new JexlBuilder().strict(true).safe(true).create();
        JexlScript e = jexl.createScript("out.println(xyz)");
        try {
            Object o = e.execute((JexlContext)ctxt);
            Assert.fail((String)"should have thrown");
        }
        catch (JexlException.Variable xvar) {
            Assert.assertEquals((Object)"xyz", (Object)xvar.getVariable());
        }
    }

    @Test
    public void test275b() throws Exception {
        MapContext ctxt = new MapContext();
        JexlEngine jexl = new JexlBuilder().strict(true).safe(true).create();
        JexlScript e = jexl.createScript("var xyz = xyz");
        try {
            Object o = e.execute((JexlContext)ctxt);
            Assert.assertNull((Object)o);
        }
        catch (JexlException.Variable xvar) {
            Assert.fail((String)"should not have thrown");
        }
    }

    @Test
    public void test275c() throws Exception {
        MapContext ctxt = new MapContext();
        JexlEngine jexl = new JexlBuilder().strict(true).safe(true).silent(true).create();
        JexlScript e = jexl.createScript("(s, v)->{  var x = y ; 42; }");
        try {
            Object r = e.execute((JexlContext)ctxt, new Object[]{false, true});
            Assert.assertEquals((Object)42, (Object)r);
        }
        catch (JexlException.Variable xjexl) {
            Assert.fail((String)"should not have thrown");
        }
    }

    @Test
    public void test275d() throws Exception {
        MapContext ctxt = new MapContext();
        ctxt.set("out", (Object)System.out);
        JexlEngine jexl = new JexlBuilder().strict(true).safe(true).create();
        JexlScript e = jexl.createScript("{ var xyz = 42 } out.println(xyz)");
        try {
            Object o = e.execute((JexlContext)ctxt);
            Assert.assertNull((Object)o);
        }
        catch (JexlException.Variable xvar) {
            Assert.fail((String)("should not have thrown" + (Object)((Object)xvar)));
        }
    }

    @Test
    public void test278() throws Exception {
        String[] srcs = new String[]{"return union x143('arg',5,6) ", "return union y143('arg',5,6)   ;", "return union\n z143('arg',5,6)   ;", "var f =()->{ return union 143 } foo[0]"};
        Object[] ctls = new Object[]{"42", "42", "42", 42};
        JexlEngine jexl = new JexlBuilder().cache(4).create();
        MapContext ctxt = new MapContext();
        int[] foo = new int[]{42};
        ctxt.set("foo", (Object)foo);
        ctxt.set("union", (Object)"42");
        for (int i = 0; i < srcs.length; ++i) {
            JexlScript jc;
            String src = srcs[i];
            try {
                jc = jexl.createScript(src);
                Assert.fail((String)("should have failed, " + (jc != null)));
            }
            catch (JexlException.Ambiguous xa) {
                String str = xa.toString();
                Assert.assertTrue((boolean)str.contains("143"));
                src = xa.tryCleanSource(src);
            }
            jc = jexl.createScript(src);
            Object value = jc.execute((JexlContext)ctxt);
            Assert.assertEquals((String)src, (Object)ctls[i], (Object)value);
        }
    }

    @Test
    public void test279() throws Exception {
        Object logger = null;
        Context279 ctxt = new Context279();
        String[] srcs = new String[]{"var z = null; identity(z[0]);", "var z = null; z.0;", "var z = null; z.foo();", "z['y']['z']", "z.y.any()", "identity(z.any())", "z[0]", "z.0", "z.foo()", "z.y[0]", "z.y[0].foo()", "z.y.0", "z.y.foo()", "var z = { 'y' : [42] }; z.y[1]", "var z = { 'y' : [42] }; z.y.1", "var z = { 'y' : [-42] }; z.y[1].foo()", "var z = { 'y' : [42] }; z.y.1.foo()", "var z = { 'y' : [null, null] }; z.y[1].foo()", "var z = { 'y' : [null, null] }; z.y.1.foo()"};
        for (int i = 0; i < 2; ++i) {
            for (boolean strict : new boolean[]{true, false}) {
                JexlEngine jexl = new JexlBuilder().safe(false).strict(strict).create();
                for (String src : srcs) {
                    JexlScript script = jexl.createScript(src);
                    try {
                        Object result = script.execute((JexlContext)ctxt);
                        if (strict) {
                            if (logger != null) {
                                logger.warn((Object)(ctxt.has("z") + ": " + src + ": no fail, " + result));
                            }
                            Assert.fail((String)("should have failed: " + src));
                        }
                        Assert.assertNull((String)"non-null result ?!", (Object)result);
                    }
                    catch (JexlException.Variable xvar) {
                        if (logger != null) {
                            logger.warn((Object)(ctxt.has("z") + ": " + src + ": fail, " + (Object)((Object)xvar)));
                        }
                        if (!strict) {
                            Assert.fail((String)(src + ", should not have thrown " + (Object)((Object)xvar)));
                            continue;
                        }
                        Assert.assertTrue((String)(src + ": " + xvar.toString()), (boolean)xvar.toString().contains("z"));
                    }
                    catch (JexlException.Property xprop) {
                        if (logger != null) {
                            logger.warn((Object)(ctxt.has("z") + ": " + src + ": fail, " + (Object)((Object)xprop)));
                        }
                        if (!strict) {
                            Assert.fail((String)(src + ", should not have thrown " + (Object)((Object)xprop)));
                            continue;
                        }
                        Assert.assertTrue((String)(src + ": " + xprop.toString()), (boolean)xprop.toString().contains("1"));
                    }
                }
            }
            ctxt.set("z.y", null);
        }
    }

    @Test
    public void test279b() throws Exception {
        Context279 ctxt = new Context279();
        ctxt.set("ctxt", (Object)ctxt);
        String src = "(x)->{ spread(x)[0].toString() }";
        JexlEngine jexl = new JexlBuilder().safe(true).strict(true).create();
        JexlScript script = jexl.createScript("(x)->{ spread(x)[0].toString() }");
        Object result = script.execute((JexlContext)ctxt, new Object[]{"abc"});
        Assert.assertEquals((Object)"a", (Object)result);
        result = null;
        try {
            result = script.execute((JexlContext)ctxt, new Object[]{null});
        }
        catch (JexlException xany) {
            Assert.assertNotNull((Object)xany.getMessage());
        }
        Assert.assertNull((Object)result);
    }

    @Test
    public void test285() throws Exception {
        ArrayList out = new ArrayList(6);
        MapContext ctxt = new MapContext();
        ctxt.set("$out", out);
        String src = "for(var b: ['g','h','i']) {\n  var c = b;\n  $out.add(c);\n}\n \nfor(var dc: ['j','k','l']) {\n  $out.add(dc);\n} \n$out.size()";
        JexlFeatures features = new JexlFeatures();
        features.lexical(true);
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).lexical(true).create();
        JexlScript script = jexl.createScript("for(var b: ['g','h','i']) {\n  var c = b;\n  $out.add(c);\n}\n \nfor(var dc: ['j','k','l']) {\n  $out.add(dc);\n} \n$out.size()");
        Object result = script.execute((JexlContext)ctxt, new Object[]{null});
        Assert.assertEquals((Object)6, (Object)result);
        List<String> ctl = Arrays.asList("g", "h", "i", "j", "k", "l");
        Assert.assertEquals(ctl, out);
    }

    @Test
    public void test285a() throws Exception {
        ArrayList out = new ArrayList(6);
        MapContext ctxt = new MapContext();
        ctxt.set("$out", out);
        String src = "for(var b: ['g','h','i']) { $out.add(b); }\nfor(b: ['j','k','l']) { $out.add(b);}\n$out.size()";
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).lexical(false).create();
        JexlScript script = jexl.createScript("for(var b: ['g','h','i']) { $out.add(b); }\nfor(b: ['j','k','l']) { $out.add(b);}\n$out.size()");
        Object result = script.execute((JexlContext)ctxt, new Object[]{null});
        Assert.assertEquals((Object)6, (Object)result);
        List<String> ctl = Arrays.asList("g", "h", "i", "j", "k", "l");
        Assert.assertEquals(ctl, out);
    }

    @Test
    public void test285b() throws Exception {
        ArrayList out = new ArrayList(6);
        MapContext ctxt = new MapContext();
        ctxt.set("$out", out);
        String src = "for(b: ['g','h','i']) { $out.add(b); }\nfor(var b: ['j','k','l']) { $out.add(b);}\n$out.size()";
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).create();
        JexlScript script = jexl.createScript("for(b: ['g','h','i']) { $out.add(b); }\nfor(var b: ['j','k','l']) { $out.add(b);}\n$out.size()");
        Object result = script.execute((JexlContext)ctxt, new Object[]{null});
        Assert.assertEquals((Object)6, (Object)result);
        List<String> ctl = Arrays.asList("g", "h", "i", "j", "k", "l");
        Assert.assertEquals(ctl, out);
    }

    @Test
    public void test286() {
        String s286 = "var x = 0; for(x : 1..2){}; return x";
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        Assert.assertEquals((Object)2, (Object)jexl.createScript("var x = 0; for(x : 1..2){}; return x").execute(null));
    }

    @Test
    public void test287() {
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        String src = "x = 1; if (false) var x = 2; x";
        JexlScript script = jexl.createScript(src);
        Object result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)1, (Object)result);
        src = "x = 1; if (true) var x = 2; x";
        script = jexl.createScript(src);
        result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)2, (Object)result);
        src = "x = 1; var x = x + 41; x";
        script = jexl.createScript(src);
        result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)42, (Object)result);
        options.setLexical(false);
        src = "(x)->{ if (x==1) { var y = 2; } else if (x==2) { var y = 3; }; y }";
        script = jexl.createScript(src);
        result = script.execute((JexlContext)ctxt, new Object[]{1});
        Assert.assertEquals((Object)2, (Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{2});
        Assert.assertEquals((Object)3, (Object)result);
        options.setStrict(true);
        try {
            result = script.execute((JexlContext)ctxt, new Object[]{0});
            Assert.fail((String)"should have failed!");
        }
        catch (JexlException.Variable xvar) {
            Assert.assertTrue((boolean)xvar.getMessage().contains("y"));
        }
        options.setStrict(false);
        try {
            result = script.execute((JexlContext)ctxt, new Object[]{0});
        }
        catch (JexlException xvar) {
            Assert.fail((String)"should not have failed!");
        }
        Assert.assertNull((Object)result);
    }

    @Test
    public void test289() {
        MapContext ctxt = new MapContext();
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        String src = "var x = function(a) { var b; return b}; x(1,2)";
        JexlScript script = jexl.createScript(src);
        Object result = script.execute((JexlContext)ctxt);
        Assert.assertNull((Object)result);
    }

    @Test
    public void test290a() throws Exception {
        String[] srcs = new String[]{"(x)->{ x.nothing().toString() }", "(x)->{ x.toString().nothing() }", "(x)->{ x.nothing().nothing() }"};
        for (boolean safe : new boolean[]{true, false}) {
            JexlEngine jexl = new JexlBuilder().safe(safe).strict(true).create();
            for (String src : srcs) {
                JexlScript script = jexl.createScript(src);
                try {
                    Object result = script.execute(null, new Object[]{"abc"});
                    if (!safe) {
                        Assert.fail((String)("should have failed: " + src));
                        continue;
                    }
                    Assert.assertNull((String)"non-null result ?!", (Object)result);
                }
                catch (JexlException.Method xmethod) {
                    if (safe) {
                        Assert.fail((String)(src + ", should not have thrown " + (Object)((Object)xmethod)));
                        continue;
                    }
                    Assert.assertTrue((String)(src + ": " + xmethod.toString()), (boolean)xmethod.toString().contains("nothing"));
                }
            }
        }
    }

    @Test
    public void test290b() throws Exception {
        String[] srcs = new String[]{"(x)->{ x?.nothing()?.toString() }", "(x)->{ x.toString()?.nothing() }", "(x)->{ x?.nothing().nothing() }"};
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        for (String src : srcs) {
            JexlScript script = jexl.createScript(src);
            Object result = script.execute(null, new Object[]{"abc"});
            Assert.assertNull((Object)result);
        }
    }

    @Test
    public void test291() throws Exception {
        String str = "{1:'one'}[1]";
        MapContext ctxt = new MapContext();
        JexlEngine jexl = new JexlBuilder().create();
        JexlExpression e = jexl.createExpression("{1:'one'}[1]");
        Object value = e.evaluate((JexlContext)ctxt);
        Assert.assertEquals((Object)"one", (Object)value);
        JexlEngine sandboxedJexlEngine = new JexlBuilder().sandbox(new JexlSandbox(true)).create();
        e = sandboxedJexlEngine.createExpression("{1:'one'}[1]");
        value = e.evaluate((JexlContext)ctxt);
        Assert.assertEquals((Object)"one", (Object)value);
    }

    @Test
    public void testTemplate6565a() throws Exception {
        JexlEngine jexl = new JexlBuilder().create();
        JxltEngine jexlt = jexl.createJxltEngine();
        String source = "$$ var res = '';\n$$ var meta = session.data['METADATA'];\n$$ if (meta) {\n$$   var entry = meta['ID'];\n$$   if (entry) {\n$$     var value = session.data[entry];\n$$     res = value?: '';\n$$   }\n$$ }\n${res}\n";
        JxltEngine.Template script = jexlt.createTemplate("$$", (Reader)new StringReader("$$ var res = '';\n$$ var meta = session.data['METADATA'];\n$$ if (meta) {\n$$   var entry = meta['ID'];\n$$   if (entry) {\n$$     var value = session.data[entry];\n$$     res = value?: '';\n$$   }\n$$ }\n${res}\n"), new String[0]);
        Assert.assertNotNull((Object)script);
        TemplateDebugger dbg = new TemplateDebugger();
        String refactored = dbg.debug(script) ? dbg.toString() : "";
        Assert.assertNotNull((Object)refactored);
        Assert.assertEquals((Object)"$$ var res = '';\n$$ var meta = session.data['METADATA'];\n$$ if (meta) {\n$$   var entry = meta['ID'];\n$$   if (entry) {\n$$     var value = session.data[entry];\n$$     res = value?: '';\n$$   }\n$$ }\n${res}\n", (Object)refactored);
    }

    @Test
    public void testTemplate6565b() throws Exception {
        JexlEngine jexl = new JexlBuilder().create();
        JxltEngine jexlt = jexl.createJxltEngine();
        String source = "$$ var res = '';\n$$ var meta = session.data['METADATA'];\n$$ if (meta) {\n$$   var entry = meta['ID'];\n$$   if (entry) {\n$$     var value = session.data[entry];\n$$     res = value?: '';\n${res}\n$$   }\n$$ }\n";
        JxltEngine.Template script = jexlt.createTemplate("$$", (Reader)new StringReader("$$ var res = '';\n$$ var meta = session.data['METADATA'];\n$$ if (meta) {\n$$   var entry = meta['ID'];\n$$   if (entry) {\n$$     var value = session.data[entry];\n$$     res = value?: '';\n${res}\n$$   }\n$$ }\n"), new String[0]);
        Assert.assertNotNull((Object)script);
        TemplateDebugger dbg = new TemplateDebugger();
        String refactored = dbg.debug(script) ? dbg.toString() : "";
        Assert.assertNotNull((Object)refactored);
        Assert.assertEquals((Object)"$$ var res = '';\n$$ var meta = session.data['METADATA'];\n$$ if (meta) {\n$$   var entry = meta['ID'];\n$$   if (entry) {\n$$     var value = session.data[entry];\n$$     res = value?: '';\n${res}\n$$   }\n$$ }\n", (Object)refactored);
    }

    @Test
    public void test298() throws Exception {
        Cls298 c298 = new Cls298();
        MapContext ctxt = new MapContext();
        JexlEngine jexl = new JexlBuilder().create();
        String str = "c.size()";
        JexlScript e = jexl.createScript(str, new String[]{"c"});
        Object value = e.execute((JexlContext)ctxt, new Object[]{c298});
        Assert.assertEquals((String)str, (Object)42, (Object)value);
        str = "size c";
        e = jexl.createScript(str, new String[]{"c"});
        value = e.execute((JexlContext)ctxt, new Object[]{c298});
        Assert.assertEquals((String)str, (Object)42, (Object)value);
        str = "c.size(127)";
        e = jexl.createScript(str, new String[]{"c"});
        value = e.execute((JexlContext)ctxt, new Object[]{c298});
        Assert.assertEquals((String)str, (Object)169, (Object)value);
    }

    public static class Cls298 {
        int sz = 42;

        public int size() {
            return this.sz;
        }

        public int size(int x) {
            return this.sz + x;
        }

        public boolean isEmpty() {
            return this.sz <= 0;
        }
    }

    public static class Context279
    extends MapContext {
        public String identity(String x) {
            return x;
        }

        public Number identity(Number x) {
            return x;
        }

        public String[] spread(String str) {
            if (str == null) {
                return null;
            }
            String[] a = new String[str.length()];
            for (int i = 0; i < str.length(); ++i) {
                a[i] = "" + str.charAt(i);
            }
            return a;
        }
    }

    public static class Arithmetic266
    extends JexlArithmetic {
        static final ThreadLocal<Deque<Iterator266>> TLS_FOREACH = new ThreadLocal<Deque<Iterator266>>(){

            @Override
            public Deque<Iterator266> initialValue() {
                return new LinkedList<Iterator266>();
            }
        };

        public Arithmetic266(boolean strict) {
            super(strict);
        }

        static void closeIterator(Iterator266 i266) {
            Deque<Iterator266> queue = TLS_FOREACH.get();
            if (queue != null) {
                queue.remove(i266);
            }
        }

        public Iterator<?> forEach(Iterable<?> collection) {
            Iterator266 it266 = new Iterator266(collection.iterator());
            Deque<Iterator266> queue = TLS_FOREACH.get();
            queue.addFirst(it266);
            return it266;
        }

        public Iterator<?> forEach(Map<?, ?> collection) {
            return this.forEach(collection.values());
        }

        public void remove() {
            Deque<Iterator266> queue = TLS_FOREACH.get();
            Iterator266 i266 = queue.getFirst();
            if (i266 != null) {
                i266.remove();
                throw new JexlException.Continue(null);
            }
            throw new NoSuchElementException();
        }
    }

    public static class Iterator266
    implements Iterator<Object> {
        private Iterator<Object> iterator;

        Iterator266(Iterator<Object> ator) {
            this.iterator = ator;
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }

        public void close() {
            if (this.iterator != null) {
                Arithmetic266.closeIterator(this);
                this.iterator = null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.iterator == null) {
                return false;
            }
            boolean n = this.iterator.hasNext();
            if (!n) {
                this.close();
            }
            return n;
        }

        @Override
        public Object next() {
            if (this.iterator == null) {
                throw new NoSuchElementException();
            }
            return this.iterator.next();
        }

        @Override
        public void remove() {
            if (this.iterator != null) {
                this.iterator.remove();
            }
        }
    }

    public static class Foo245 {
        private Object bar = null;

        void setBar(Object bar) {
            this.bar = bar;
        }

        public Object getBar() {
            return this.bar;
        }
    }

    public static class Context225
    extends MapContext {
        public String bar() {
            return "bar";
        }
    }

    public static class JexlArithmetic224
    extends JexlArithmetic {
        public JexlArithmetic224(boolean astrict) {
            super(astrict);
        }

        protected Object nth(Collection<?> c, int i) {
            if (c instanceof List) {
                return JexlEngine.TRY_FAILED;
            }
            for (Object o : c) {
                if (i-- != 0) continue;
                return o;
            }
            return null;
        }

        public Object propertyGet(Collection<?> c, Number n) {
            return this.nth(c, n.intValue());
        }

        public Object arrayGet(Collection<?> c, Number n) {
            return this.nth(c, n.intValue());
        }

        public Object call(Collection<?> c, Number n) {
            if (c instanceof List) {
                return ((List)c).get(n.intValue());
            }
            return this.nth(c, n.intValue());
        }
    }

    public static class T210 {
        public void npe() {
            throw new NullPointerException("NPE210");
        }
    }

    public static class Eval {
        private JexlEngine jexl;

        public JexlScript fn(String src) {
            return this.jexl.createScript(src);
        }

        void setJexl(JexlEngine je) {
            this.jexl = je;
        }
    }
}

