/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.core;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadTag
extends TagSupport {
    private String name = null;
    private XMLOutput xmlOutput;
    private boolean closeOutput;
    private static final Log log = LogFactory.getLog(ThreadTag.class);

    public void doTag(XMLOutput output) throws JellyTagException {
        if (this.xmlOutput == null) {
            try {
                this.xmlOutput = XMLOutput.createXMLOutput(System.out);
            }
            catch (UnsupportedEncodingException e) {
                throw new JellyTagException(e);
            }
        }
        final JellyContext newContext = this.context.newJellyContext();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                block4: {
                    try {
                        ThreadTag.this.getBody().run(newContext, ThreadTag.this.xmlOutput);
                        if (ThreadTag.this.closeOutput) {
                            ThreadTag.this.xmlOutput.close();
                        } else {
                            ThreadTag.this.xmlOutput.flush();
                        }
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) break block4;
                        log.error((Object)"error running thread tag", (Throwable)e);
                    }
                }
            }
        });
        if (this.name != null) {
            thread.setName(this.name);
        }
        thread.start();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setXmlOutput(XMLOutput xmlOutput) {
        this.closeOutput = false;
        this.xmlOutput = xmlOutput;
    }

    public void setFile(String name) throws IOException {
        this.closeOutput = true;
        this.setXmlOutput(XMLOutput.createXMLOutput(new FileOutputStream(name)));
    }
}

