/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class Procedure
implements ConfigurationNode,
CayenneMapEntry,
XMLSerializable,
Serializable {
    protected String name;
    protected DataMap dataMap;
    protected String catalog;
    protected String schema;
    protected boolean returningValue;
    protected List<ProcedureParameter> callParameters = new ArrayList<ProcedureParameter>();

    public Procedure() {
    }

    public Procedure(String name) {
        this.setName(name);
    }

    @Override
    public <T> T acceptVisitor(ConfigurationNodeVisitor<T> visitor) {
        return visitor.visitProcedure(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Object getParent() {
        return this.getDataMap();
    }

    @Override
    public void setParent(Object parent) {
        if (parent != null && !(parent instanceof DataMap)) {
            throw new IllegalArgumentException("Expected null or DataMap, got: " + parent);
        }
        this.setDataMap((DataMap)parent);
    }

    public void encodeAsXML(XMLEncoder encoder, ConfigurationNodeVisitor delegate) {
        encoder.start("procedure").attribute("name", this.getName()).attribute("schema", this.getSchema()).attribute("catalog", this.getCatalog()).attribute("returningValue", this.isReturningValue()).nested(this.getCallParameters(), delegate);
        delegate.visitProcedure(this);
        encoder.end();
    }

    public String getFullyQualifiedName() {
        return Procedure.generateFullyQualifiedName(this.catalog, this.schema, this.name);
    }

    public static String generateFullyQualifiedName(String catalog, String schema, String name) {
        return (String)(catalog != null && !catalog.isEmpty() ? catalog + "." : "") + (String)(schema != null && !schema.isEmpty() ? schema + "." : "") + name;
    }

    public DataMap getDataMap() {
        return this.dataMap;
    }

    public void setDataMap(DataMap dataMap) {
        this.dataMap = dataMap;
    }

    public void setCallParameters(List<ProcedureParameter> parameters) {
        this.clearCallParameters();
        this.callParameters.addAll(parameters);
    }

    public void addCallParameter(ProcedureParameter param) {
        if (param.getName() == null) {
            throw new IllegalArgumentException("Attempt to add unnamed parameter.");
        }
        if (this.callParameters.contains(param)) {
            throw new IllegalArgumentException("Attempt to add the same parameter more than once:" + param);
        }
        param.setProcedure(this);
        this.callParameters.add(param);
    }

    public void removeCallParameter(String name) {
        for (int i = 0; i < this.callParameters.size(); ++i) {
            ProcedureParameter nextParam = this.callParameters.get(i);
            if (!name.equals(nextParam.getName())) continue;
            this.callParameters.remove(i);
            break;
        }
    }

    public void clearCallParameters() {
        this.callParameters.clear();
    }

    public List<ProcedureParameter> getCallParameters() {
        return Collections.unmodifiableList(this.callParameters);
    }

    public List<ProcedureParameter> getCallOutParameters() {
        ArrayList<ProcedureParameter> outParams = new ArrayList<ProcedureParameter>(this.callParameters.size());
        for (ProcedureParameter param : this.callParameters) {
            if (!param.isOutParam()) continue;
            outParams.add(param);
        }
        return outParams;
    }

    public ProcedureParameter getResultParam() {
        return this.returningValue && this.callParameters.size() > 0 ? this.callParameters.get(0) : null;
    }

    public boolean isReturningValue() {
        return this.returningValue;
    }

    public void setReturningValue(boolean returningValue) {
        this.returningValue = returningValue;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setCatalog(String string) {
        this.catalog = string;
    }

    public void setSchema(String string) {
        this.schema = string;
    }
}

