/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.sqlbuilder.sqltree;

import java.util.Objects;
import org.apache.cayenne.access.sqlbuilder.QuotingAppendable;
import org.apache.cayenne.access.sqlbuilder.sqltree.ExpressionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.NodeType;

public class LikeNode
extends ExpressionNode {
    protected final boolean ignoreCase;
    protected final boolean not;
    protected final char escape;

    public LikeNode(boolean ignoreCase, boolean not, char escape) {
        super(NodeType.LIKE);
        this.ignoreCase = ignoreCase;
        this.not = not;
        this.escape = escape;
    }

    @Override
    public void appendChildrenStart(QuotingAppendable buffer) {
        if (this.ignoreCase) {
            buffer.append(" UPPER(");
        }
    }

    @Override
    public void appendChildrenSeparator(QuotingAppendable buffer, int childIdx) {
        if (this.ignoreCase) {
            buffer.append(')');
        }
        if (this.not) {
            buffer.append(" NOT");
        }
        buffer.append(" LIKE");
        if (this.ignoreCase) {
            buffer.append(" UPPER(");
        }
    }

    @Override
    public void appendChildrenEnd(QuotingAppendable buffer) {
        if (this.ignoreCase) {
            buffer.append(')');
        }
        if (this.escape != '\u0000') {
            buffer.append(" ESCAPE '").append(this.escape).append('\'');
        }
    }

    @Override
    public Node copy() {
        return new LikeNode(this.ignoreCase, this.not, this.escape);
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean isNot() {
        return this.not;
    }

    public char getEscape() {
        return this.escape;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LikeNode likeNode = (LikeNode)o;
        return this.ignoreCase == likeNode.ignoreCase && this.not == likeNode.not && this.escape == likeNode.escape;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.ignoreCase, this.not, Character.valueOf(this.escape));
    }
}

