/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project;

import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.ListBuilder;
import org.apache.cayenne.project.extension.ProjectExtension;
import org.apache.cayenne.project.upgrade.handlers.UpgradeHandler;

public class ProjectModuleExtender {
    private final Binder binder;
    private ListBuilder<UpgradeHandler> upgradeHandlers;
    private ListBuilder<ProjectExtension> extensions;

    public ProjectModuleExtender(Binder binder) {
        this.binder = binder;
    }

    protected ProjectModuleExtender initAllExtensions() {
        this.contributeExtensions();
        this.contributeUpgradeHandler();
        return this;
    }

    public ProjectModuleExtender addUpgradeHandler(UpgradeHandler handler) {
        this.contributeUpgradeHandler().add((Object)handler);
        return this;
    }

    public ProjectModuleExtender addUpgradeHandler(Class<? extends UpgradeHandler> handler) {
        this.contributeUpgradeHandler().add(handler);
        return this;
    }

    public ProjectModuleExtender addExtension(ProjectExtension extension) {
        this.contributeExtensions().add((Object)extension);
        return this;
    }

    public ProjectModuleExtender addExtension(Class<? extends ProjectExtension> extension) {
        this.contributeExtensions().add(extension);
        return this;
    }

    private ListBuilder<ProjectExtension> contributeExtensions() {
        if (this.extensions == null) {
            this.extensions = this.binder.bindList(ProjectExtension.class);
        }
        return this.extensions;
    }

    private ListBuilder<UpgradeHandler> contributeUpgradeHandler() {
        if (this.upgradeHandlers == null) {
            this.upgradeHandlers = this.binder.bindList(UpgradeHandler.class);
        }
        return this.upgradeHandlers;
    }
}

