/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.KeyStroke;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.dbsync.merge.context.EntityMergeSupport;
import org.apache.cayenne.dbsync.naming.DefaultObjectNameGenerator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.objentity.EntitySyncController;
import org.apache.cayenne.modeler.undo.DbEntitySyncUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.CayenneController;

public class DbEntitySyncAction
extends CayenneAction {
    public static String getActionName() {
        return "Sync Dependent ObjEntities with DbEntity";
    }

    public DbEntitySyncAction(Application application) {
        super(DbEntitySyncAction.getActionName(), application);
    }

    @Override
    public KeyStroke getAcceleratorKey() {
        return KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    @Override
    public String getIconName() {
        return "icon-sync.png";
    }

    @Override
    public void performAction(ActionEvent e) {
        this.syncDbEntity();
    }

    protected void syncDbEntity() {
        ProjectController mediator = this.getProjectController();
        DbEntity dbEntity = mediator.getCurrentDbEntity();
        if (dbEntity != null) {
            Collection<ObjEntity> entities = dbEntity.getDataMap().getMappedEntities(dbEntity);
            if (entities.isEmpty()) {
                return;
            }
            EntityMergeSupport merger = new EntitySyncController((CayenneController)Application.getInstance().getFrameController(), dbEntity).createMerger();
            if (merger == null) {
                return;
            }
            merger.setNameGenerator(new PreserveRelationshipNameGenerator());
            DbEntitySyncUndoableEdit undoableEdit = new DbEntitySyncUndoableEdit((DataChannelDescriptor)mediator.getProject().getRootNode(), mediator.getCurrentDataMap());
            this.filterInheritedEntities(entities);
            boolean hasChanges = false;
            for (ObjEntity entity : entities) {
                DbEntitySyncUndoableEdit dbEntitySyncUndoableEdit = undoableEdit;
                dbEntitySyncUndoableEdit.getClass();
                DbEntitySyncUndoableEdit.EntitySyncUndoableListener listener = new DbEntitySyncUndoableEdit.EntitySyncUndoableListener(dbEntitySyncUndoableEdit, entity);
                merger.addEntityMergeListener(listener);
                Collection<DbAttribute> meaningfulFKs = merger.getMeaningfulFKs(entity);
                if (merger.isRemovingMeaningfulFKs() && !meaningfulFKs.isEmpty()) {
                    DbEntitySyncUndoableEdit dbEntitySyncUndoableEdit2 = undoableEdit;
                    dbEntitySyncUndoableEdit2.getClass();
                    undoableEdit.addEdit(new DbEntitySyncUndoableEdit.MeaningfulFKsUndoableEdit(dbEntitySyncUndoableEdit2, entity, meaningfulFKs));
                    hasChanges = true;
                }
                if (merger.synchronizeWithDbEntity(entity)) {
                    mediator.fireObjEntityEvent(new EntityEvent((Object)this, (Entity)entity, 1));
                    hasChanges = true;
                }
                merger.removeEntityMergeListener(listener);
            }
            if (hasChanges) {
                this.application.getUndoManager().addEdit(undoableEdit);
            }
        }
    }

    private void filterInheritedEntities(Collection<ObjEntity> entities) {
        Iterator<ObjEntity> it = entities.iterator();
        while (it.hasNext()) {
            if (it.next().getSuperEntity() == null) continue;
            it.remove();
        }
    }

    static class PreserveRelationshipNameGenerator
    extends DefaultObjectNameGenerator {
        PreserveRelationshipNameGenerator() {
        }

        @Override
        public String relationshipName(DbRelationship ... relationshipChain) {
            if (relationshipChain.length == 0) {
                return super.relationshipName(relationshipChain);
            }
            DbRelationship last = relationshipChain[relationshipChain.length - 1];
            if (last.getName().startsWith("untitledRel")) {
                return super.relationshipName(relationshipChain);
            }
            return last.getName();
        }
    }
}

