/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.Serializable;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class ProcedureParameter
implements ConfigurationNode,
CayenneMapEntry,
XMLSerializable,
Serializable {
    public static final int IN_OUT_PARAMETER = 3;
    public static final int IN_PARAMETER = 1;
    public static final int OUT_PARAMETER = 2;
    protected String name;
    protected Procedure procedure;
    protected int direction = -1;
    protected int maxLength = -1;
    protected int precision = -1;
    protected int type = Integer.MAX_VALUE;

    public ProcedureParameter() {
    }

    public ProcedureParameter(String name) {
        this.setName(name);
    }

    public ProcedureParameter(String name, int type, int direction) {
        this(name);
        this.setType(type);
        this.setDirection(direction);
    }

    @Override
    public <T> T acceptVisitor(ConfigurationNodeVisitor<T> visitor) {
        return visitor.visitProcedureParameter(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Object getParent() {
        return this.getProcedure();
    }

    @Override
    public void setParent(Object parent) {
        if (parent != null && !(parent instanceof Procedure)) {
            throw new IllegalArgumentException("Expected null or Procedure, got: " + parent);
        }
        this.setProcedure((Procedure)parent);
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        int direction;
        encoder.print("<procedure-parameter name=\"" + Util.encodeXmlAttribute(this.getName()) + '\"');
        String type = TypesMapping.getSqlNameByType(this.getType());
        if (type != null) {
            encoder.print(" type=\"" + type + '\"');
        }
        if (this.getMaxLength() > 0) {
            encoder.print(" length=\"");
            encoder.print(this.getMaxLength());
            encoder.print('\"');
        }
        if (this.getPrecision() > 0) {
            encoder.print(" precision=\"");
            encoder.print(this.getPrecision());
            encoder.print('\"');
        }
        if ((direction = this.getDirection()) == 1) {
            encoder.print(" direction=\"in\"");
        } else if (direction == 3) {
            encoder.print(" direction=\"in_out\"");
        } else if (direction == 2) {
            encoder.print(" direction=\"out\"");
        }
        encoder.println("/>");
    }

    public int getDirection() {
        return this.direction;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getType() {
        return this.type;
    }

    public boolean isInParameter() {
        return this.direction == 1 || this.direction == 3;
    }

    public boolean isOutParam() {
        return this.direction == 2 || this.direction == 3;
    }

    public void setDirection(int direction) {
        if (direction != 1 && direction != 2 && direction != 3) {
            throw new IllegalArgumentException("Unknown parameter type: " + direction);
        }
        this.direction = direction;
    }

    public void setMaxLength(int i) {
        this.maxLength = i;
    }

    public void setPrecision(int i) {
        this.precision = i;
    }

    public void setType(int i) {
        this.type = i;
    }

    public Procedure getProcedure() {
        return this.procedure;
    }

    public void setProcedure(Procedure procedure) {
        this.procedure = procedure;
    }
}

