/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.binders;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.binders.BindMapToHeadersWithPrefix;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindUserMetadataToHeadersWithPrefix
implements Binder {
    private final BindMapToHeadersWithPrefix metadataPrefixer;

    @Inject
    public BindUserMetadataToHeadersWithPrefix(BindMapToHeadersWithPrefix metadataPrefixer) {
        this.metadataPrefixer = (BindMapToHeadersWithPrefix)Preconditions.checkNotNull((Object)metadataPrefixer, (Object)"metadataPrefixer");
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof Blob), (Object)"this binder is only valid for Blobs!");
        Preconditions.checkNotNull(request, (Object)"request");
        return this.metadataPrefixer.bindToRequest(request, ((Blob)Blob.class.cast(input)).getMetadata().getUserMetadata());
    }
}

