/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.KeyToPath;
import io.fabric8.kubernetes.api.model.KeyToPathBuilder;
import io.fabric8.kubernetes.api.model.KeyToPathFluentImpl;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.fabric8.kubernetes.api.model.SecretVolumeSourceFluent;
import java.util.ArrayList;
import java.util.List;

public class SecretVolumeSourceFluentImpl<A extends SecretVolumeSourceFluent<A>>
extends BaseFluent<A>
implements SecretVolumeSourceFluent<A> {
    private List<VisitableBuilder<? extends KeyToPath, ?>> items = new ArrayList();
    private String secretName;

    public SecretVolumeSourceFluentImpl() {
    }

    public SecretVolumeSourceFluentImpl(SecretVolumeSource instance) {
        this.withItems(instance.getItems());
        this.withSecretName(instance.getSecretName());
    }

    @Override
    public A addToItems(KeyToPath ... items) {
        for (KeyToPath item : items) {
            KeyToPathBuilder builder = new KeyToPathBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(KeyToPath ... items) {
        for (KeyToPath item : items) {
            KeyToPathBuilder builder = new KeyToPathBuilder(item);
            this._visitables.remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<KeyToPath> getItems() {
        return SecretVolumeSourceFluentImpl.build(this.items);
    }

    @Override
    public A withItems(List<KeyToPath> items) {
        this._visitables.removeAll(this.items);
        this.items.clear();
        if (items != null) {
            for (KeyToPath item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withItems(KeyToPath ... items) {
        this.items.clear();
        if (items != null) {
            for (KeyToPath item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public SecretVolumeSourceFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public SecretVolumeSourceFluent.ItemsNested<A> addNewItemLike(KeyToPath item) {
        return new ItemsNestedImpl(item);
    }

    @Override
    public A addNewItem(String key, String path) {
        return this.addToItems(new KeyToPath(key, path));
    }

    @Override
    public String getSecretName() {
        return this.secretName;
    }

    @Override
    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretVolumeSourceFluentImpl that = (SecretVolumeSourceFluentImpl)o;
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        return !(this.secretName != null ? !this.secretName.equals(that.secretName) : that.secretName != null);
    }

    public class ItemsNestedImpl<N>
    extends KeyToPathFluentImpl<SecretVolumeSourceFluent.ItemsNested<N>>
    implements SecretVolumeSourceFluent.ItemsNested<N>,
    Nested<N> {
        private final KeyToPathBuilder builder;

        ItemsNestedImpl(KeyToPath item) {
            this.builder = new KeyToPathBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.builder = new KeyToPathBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecretVolumeSourceFluentImpl.this.addToItems(this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

