/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.msgprocessors;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.polling.PollingManager;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.FaultManager;
import org.apache.sandesha2.util.Range;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.TerminateManager;
import org.apache.sandesha2.wsrm.SequenceAcknowledgement;

public class AcknowledgementProcessor {
    private static final Log log = LogFactory.getLog(AcknowledgementProcessor.class);

    public void processAckHeaders(RMMsgContext message) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: AcknowledgementProcessor::processAckHeaders");
        }
        Iterator<SequenceAcknowledgement> iter = message.getSequenceAcknowledgements();
        while (iter.hasNext()) {
            SequenceAcknowledgement sa = iter.next();
            this.processAckHeader(message, sa.getOriginalSequenceAckElement(), sa);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: AcknowledgementProcessor::processAckHeaders");
        }
    }

    private void processAckHeader(RMMsgContext rmMsgCtx, OMElement soapHeader, SequenceAcknowledgement sequenceAck) throws AxisFault {
        PollingManager manager;
        RMDBeanMgr rMDBeanMgr;
        RMDBean rMDBean;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: AcknowledgementProcessor::processAckHeader " + soapHeader));
        }
        boolean piggybackedAck = rmMsgCtx.getMessageType() != 4;
        MessageContext msgCtx = rmMsgCtx.getMessageContext();
        ConfigurationContext configCtx = msgCtx.getConfigurationContext();
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configCtx, (AxisDescription)configCtx.getAxisConfiguration());
        SenderBeanMgr retransmitterMgr = storageManager.getSenderBeanMgr();
        String outSequenceId = sequenceAck.getIdentifier().getIdentifier();
        RMSBean rmsBean = SandeshaUtil.getRMSBeanFromSequenceId(storageManager, outSequenceId);
        if (rmsBean == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: AcknowledgementProcessor::processAckHeader, Sequence bean not found");
            }
            return;
        }
        if (outSequenceId == null || outSequenceId.length() == 0) {
            String message = SandeshaMessageHelper.getMessage("outSeqIDIsNull");
            log.debug((Object)message);
            throw new SandeshaException(message);
        }
        if (rmMsgCtx.getMessageType() != 7 && FaultManager.checkForSequenceTerminated(rmMsgCtx, outSequenceId, rmsBean, piggybackedAck)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: AcknowledgementProcessor::processAckHeader, Sequence terminated");
            }
            return;
        }
        String internalSequenceId = rmsBean.getInternalSequenceID();
        SandeshaUtil.assertProofOfPossession(rmsBean, msgCtx, soapHeader);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Got Ack for RM Sequence: " + outSequenceId + ", internalSeqId: " + internalSequenceId));
        }
        Iterator<Range> ackRangeIterator = sequenceAck.getAcknowledgementRanges().iterator();
        if (FaultManager.checkForInvalidAcknowledgement(rmMsgCtx, sequenceAck, storageManager, rmsBean, piggybackedAck)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: AcknowledgementProcessor::processAckHeader, Invalid Ack range ");
            }
            return;
        }
        EndpointReference replyTo = rmsBean.getReplyToEndpointReference();
        boolean anonReplyTo = replyTo == null || replyTo.isWSAddressingAnonymous();
        RangeString completedMessages = rmsBean.getClientCompletedMessages();
        long numberOfNewMessagesAcked = 0L;
        boolean ackNeedsToSendInvalidFault = false;
        Range firstInvalidRange = null;
        if (rmsBean.getOfferedSequence() != null && (rMDBean = (rMDBeanMgr = storageManager.getRMDBeanMgr()).retrieve(outSequenceId)) != null && rMDBean.isPollingMode() && (manager = storageManager.getPollingManager()) != null) {
            manager.schedulePollingRequest(rMDBean.getSequenceID(), false);
        }
        while (ackRangeIterator.hasNext()) {
            Range ackRange = ackRangeIterator.next();
            long lower = ackRange.lowerValue;
            long upper = ackRange.upperValue;
            Range ackedRange = new Range(lower, upper);
            if (completedMessages.isRangeCompleted(ackedRange)) continue;
            Range[] newRanges = completedMessages.addRange(ackedRange).getRanges();
            for (int rangeIndex = 0; rangeIndex < newRanges.length; ++rangeIndex) {
                for (long messageNo = newRanges[rangeIndex].lowerValue; messageNo <= newRanges[rangeIndex].upperValue; ++messageNo) {
                    MessageContext applicationMessage;
                    AxisOperation operation;
                    ++numberOfNewMessagesAcked;
                    SenderBean retransmitterBean = retransmitterMgr.retrieve(outSequenceId, messageNo);
                    if (retransmitterBean == null || retransmitterBean.getMessageType() != 3) continue;
                    if (retransmitterBean.getSentCount() == 0) {
                        if (ackNeedsToSendInvalidFault) continue;
                        ackNeedsToSendInvalidFault = true;
                        firstInvalidRange = newRanges[rangeIndex];
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("unsent msg has been acked " + retransmitterBean));
                        continue;
                    }
                    String storageKey = retransmitterBean.getMessageContextRefKey();
                    boolean syncResponseNeeded = false;
                    if (anonReplyTo && (operation = (applicationMessage = storageManager.retrieveMessageContext(storageKey, configCtx)).getAxisOperation()) != null) {
                        int mep = operation.getAxisSpecificMEPConstant();
                        boolean bl = syncResponseNeeded = mep == 16;
                    }
                    if (syncResponseNeeded) continue;
                    retransmitterMgr.delete(retransmitterBean.getMessageID());
                    storageManager.removeMessageContext(storageKey);
                }
            }
        }
        if (ackNeedsToSendInvalidFault) {
            FaultManager.makeInvalidAcknowledgementFault(rmMsgCtx, sequenceAck, firstInvalidRange, storageManager, piggybackedAck, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: AcknowledgementProcessor::processAckHeader, Invalid Ack as message has not been sent");
            }
            return;
        }
        rmsBean.setLastActivatedTime(System.currentTimeMillis());
        if (numberOfNewMessagesAcked > 0L) {
            rmsBean.setClientCompletedMessages(completedMessages);
        }
        storageManager.getRMSBeanMgr().update(rmsBean);
        if (!rmsBean.isAvoidAutoTermination()) {
            TerminateManager.checkAndTerminate(rmMsgCtx.getConfigurationContext(), storageManager, rmsBean);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: AcknowledgementProcessor::processAckHeader");
        }
    }
}

