/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server.dispatcher;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.WebServiceExceptionLogger;
import org.apache.axis2.jaxws.context.utils.ContextUtils;
import org.apache.axis2.jaxws.server.EndpointCallback;
import org.apache.axis2.jaxws.server.EndpointInvocationContext;
import org.apache.axis2.jaxws.server.InvocationHelper;
import org.apache.axis2.jaxws.server.InvocationListener;
import org.apache.axis2.jaxws.server.InvocationListenerBean;
import org.apache.axis2.jaxws.server.dispatcher.EndpointDispatcher;
import org.apache.axis2.jaxws.utility.ClassUtils;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.axis2.kernel.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JavaDispatcher
implements EndpointDispatcher {
    private static final Log log = LogFactory.getLog(JavaDispatcher.class);
    protected Class serviceImplClass;
    protected Object serviceInstance;

    protected JavaDispatcher(Class impl, Object serviceInstance) {
        this.serviceImplClass = impl;
        this.serviceInstance = serviceInstance;
    }

    @Override
    public abstract org.apache.axis2.jaxws.core.MessageContext invoke(org.apache.axis2.jaxws.core.MessageContext var1) throws Exception;

    @Override
    public abstract void invokeOneWay(org.apache.axis2.jaxws.core.MessageContext var1);

    @Override
    public abstract void invokeAsync(org.apache.axis2.jaxws.core.MessageContext var1, EndpointCallback var2);

    protected abstract org.apache.axis2.jaxws.core.MessageContext createResponse(org.apache.axis2.jaxws.core.MessageContext var1, Object[] var2, Object var3);

    protected abstract org.apache.axis2.jaxws.core.MessageContext createFaultResponse(org.apache.axis2.jaxws.core.MessageContext var1, Throwable var2);

    public Class getServiceImplementationClass() {
        return this.serviceImplClass;
    }

    protected Object invokeTargetOperation(Method method, Object[] args) throws Throwable {
        Object output = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)this.logContextClassLoader("Before invocation"));
            }
            output = method.invoke(this.serviceInstance, args);
            if (log.isDebugEnabled()) {
                log.debug((Object)this.logContextClassLoader("After invocation"));
            }
        }
        catch (Throwable t) {
            WebServiceExceptionLogger.log(method, t, false, this.serviceImplClass, this.serviceInstance, args);
            if (log.isDebugEnabled()) {
                this.logContextClassLoader("After invocation caught exception " + t.toString());
            }
            throw t;
        }
        return output;
    }

    String logContextClassLoader(String appendString) {
        String logMessage = null;
        try {
            logMessage = "Current ThreadContextClassLoader";
            if (appendString != null) {
                logMessage = logMessage + ": " + appendString;
            }
            logMessage = logMessage + ": " + JavaDispatcher.getCurrentContextClassLoader();
        }
        catch (Throwable t) {
            logMessage = "Unable to log current thread context classloader due to Throwable: " + t.toString();
        }
        return logMessage;
    }

    private static ClassLoader getCurrentContextClassLoader() {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception wrappedE;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            if ((wrappedE = e.getException()) instanceof RuntimeException) {
                throw (RuntimeException)wrappedE;
            }
            throw new RuntimeException(wrappedE);
        }
        return cl;
    }

    protected void responseReady(EndpointInvocationContext eic) {
        List<InvocationListener> listenerList = eic.getInvocationListeners();
        if (listenerList != null) {
            InvocationListenerBean bean = new InvocationListenerBean(eic, InvocationListenerBean.State.RESPONSE);
            for (InvocationListener listener : listenerList) {
                try {
                    listener.notify(bean);
                }
                catch (Exception e) {
                    throw ExceptionFactory.makeWebServiceException((Throwable)e);
                }
            }
        }
    }

    protected static void setFaultResponseAction(Throwable exception, org.apache.axis2.jaxws.core.MessageContext request, org.apache.axis2.jaxws.core.MessageContext response) {
        AxisOperation operation = request.getOperationDescription().getAxisOperation();
        if (operation != null) {
            String className = (exception = ClassUtils.getRootCause(exception)).getClass().getName();
            String action = operation.getFaultAction(className);
            if (action == null) {
                className = className.substring(className.lastIndexOf(46) + 1);
                action = operation.getFaultAction(className);
            }
            if (log.isDebugEnabled()) {
                for (String faultActionName : operation.getFaultActionNames()) {
                    log.debug((Object)("Fault action map entry: key = " + faultActionName + ", value = " + operation.getFaultAction(faultActionName)));
                }
            }
            if (action != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting fault action " + action + " for Exception: " + className));
                }
                response.getAxisMessageContext().setWSAAction(action);
            }
        }
    }

    protected static void setCheckedExceptionProperty(org.apache.axis2.jaxws.core.MessageContext response, Method m, Throwable t) {
        Class checkedException;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entered JavaDispatcher.setCheckedExceptionProperty(), t=" + t));
        }
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getTargetException();
        }
        if ((checkedException = JavaUtils.getCheckedException(t, m)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The exception is a checked exception: " + checkedException.getCanonicalName()));
            }
            response.setProperty("org.apache.axis2.jaxws.checkedException", checkedException.getCanonicalName());
            AxisFault fault = response.getCausedByException();
            if (fault != null) {
                fault.setFaultType(1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting AxisFault's fault type to 'APPLICATION_FAULT': " + (Object)((Object)fault)));
                }
            }
        }
    }

    protected static void setWebMethodExceptionProperty(org.apache.axis2.jaxws.core.MessageContext response, Throwable t) {
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getTargetException();
        }
        if (t != null) {
            response.setProperty("jaxws.outbound.response.webmethod.exception", t);
        }
    }

    protected static void setExceptionProperties(org.apache.axis2.jaxws.core.MessageContext response, Method m, Throwable t) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering JavaDispatcher.setExceptionProperties().");
        }
        JavaDispatcher.setCheckedExceptionProperty(response, m, t);
        JavaDispatcher.setWebMethodExceptionProperty(response, t);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving JavaDispatcher.setExceptionProperties().");
        }
    }

    protected class AsyncInvocationWorker
    implements Callable {
        private Method method;
        private Object[] params;
        private ClassLoader classLoader;
        private EndpointInvocationContext eic;

        public AsyncInvocationWorker(Method m, Object[] p, ClassLoader cl, EndpointInvocationContext ctx) {
            this.method = m;
            this.params = p;
            this.classLoader = cl;
            this.eic = ctx;
        }

        public Object call() throws Exception {
            block19: {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Invoking target endpoint via the async worker.");
                    }
                    ClassLoader currentLoader = JavaDispatcher.getCurrentContextClassLoader();
                    if (this.classLoader != null && this.classLoader != currentLoader) {
                        Thread.currentThread().setContextClassLoader(this.classLoader);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Context ClassLoader set to:" + this.classLoader));
                        }
                    }
                    Object output = null;
                    boolean faultThrown = false;
                    Throwable fault = null;
                    try {
                        output = JavaDispatcher.this.invokeTargetOperation(this.method, this.params);
                    }
                    catch (Exception e) {
                        fault = ClassUtils.getRootCause(e);
                        Throwable newFault = InvocationHelper.determineMappedException(fault, this.eic);
                        if (newFault != null) {
                            fault = newFault;
                        }
                        faultThrown = true;
                    }
                    if (this.eic.isOneWay()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Completed invoke of one-way operation");
                            log.debug((Object)"Release resources");
                        }
                        ContextUtils.releaseWebServiceContextResources(this.eic.getRequestMessageContext());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Indicate Response ready");
                        }
                        JavaDispatcher.this.responseReady(this.eic);
                        return null;
                    }
                    org.apache.axis2.jaxws.core.MessageContext request = this.eic.getRequestMessageContext();
                    org.apache.axis2.jaxws.core.MessageContext response = null;
                    if (faultThrown) {
                        response = JavaDispatcher.this.createFaultResponse(request, fault);
                        JavaDispatcher.setExceptionProperties(response, this.method, fault);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Async invocation of the endpoint was successful.  Creating response message.");
                        }
                        response = JavaDispatcher.this.createResponse(request, this.params, output);
                    }
                    EndpointInvocationContext eic = null;
                    if (request.getInvocationContext() != null) {
                        eic = (EndpointInvocationContext)request.getInvocationContext();
                        eic.setResponseMessageContext(response);
                    }
                    EndpointCallback callback = eic.getCallback();
                    boolean handleFault = response.getMessage().isFault();
                    if (!handleFault) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"No fault detected in response message, sending back application response.");
                        }
                        callback.handleResponse(eic);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"A fault was detected.  Sending back a fault response.");
                        }
                        callback.handleFaultResponse(eic);
                    }
                    Thread.currentThread().setContextClassLoader(currentLoader);
                    TransportUtils.deleteAttachments((MessageContext)eic.getRequestMessageContext().getAxisMessageContext());
                    TransportUtils.deleteAttachments((MessageContext)eic.getResponseMessageContext().getAxisMessageContext());
                }
                catch (Throwable e) {
                    if (!log.isDebugEnabled()) break block19;
                    log.debug((Object)"AN UNEXPECTED ERROR OCCURRED IN THE ASYNC WORKER THREAD");
                    log.debug((Object)("Exception is:" + e), e);
                }
            }
            return null;
        }
    }
}

