/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.util.Objects;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.api.IMetadataEntity;

public class Database
implements IMetadataEntity<Database> {
    private static final long serialVersionUID = 1L;
    private final String databaseName;
    private final boolean isSystemDatabase;
    private final int pendingOp;

    public Database(String databaseName, boolean isSystemDatabase, int pendingOp) {
        this.databaseName = databaseName;
        this.isSystemDatabase = isSystemDatabase;
        this.pendingOp = pendingOp;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean isSystemDatabase() {
        return this.isSystemDatabase;
    }

    public int getPendingOp() {
        return this.pendingOp;
    }

    @Override
    public Database addToCache(MetadataCache cache) {
        return cache.addDatabaseIfNotExists(this);
    }

    @Override
    public Database dropFromCache(MetadataCache cache) {
        return cache.dropDatabase(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.databaseName;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Database)) {
            return false;
        }
        Database other = (Database)o;
        return Objects.equals(this.databaseName, other.databaseName);
    }

    public int hashCode() {
        return Objects.hash(this.databaseName);
    }
}

