/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.constants;

import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AMissing;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.base.IAObject;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;

public class AsterixConstantValue
implements IAlgebricksConstantValue {
    private final IAObject object;

    public AsterixConstantValue(IAObject object) {
        this.object = object;
    }

    public boolean isFalse() {
        return this.object == ABoolean.FALSE;
    }

    public boolean isMissing() {
        return this.object == AMissing.MISSING;
    }

    public boolean isNull() {
        return this.object == ANull.NULL;
    }

    public boolean isTrue() {
        return this.object == ABoolean.TRUE;
    }

    public IAObject getObject() {
        return this.object;
    }

    public String toString() {
        return this.object.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof AsterixConstantValue) {
            AsterixConstantValue v2 = (AsterixConstantValue)o;
            return this.object.deepEqual(v2.getObject());
        }
        if (o instanceof IAlgebricksConstantValue) {
            return o.equals(this);
        }
        return false;
    }

    public int hashCode() {
        switch (this.object.getType().getTypeTag()) {
            case MISSING: {
                return ConstantExpression.MISSING.hashCode();
            }
            case NULL: {
                return ConstantExpression.NULL.hashCode();
            }
            case BOOLEAN: {
                return (this.isTrue() ? ConstantExpression.TRUE : ConstantExpression.FALSE).hashCode();
            }
        }
        return this.object.hash();
    }
}

