/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ARecordSerializerDeserializer;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class FieldAccessByIndexEvalFactory
implements IScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;
    private final IScalarEvaluatorFactory recordEvalFactory;
    private final IScalarEvaluatorFactory fieldIndexEvalFactory;
    private final int nullBitmapSize;
    private final ARecordType recordType;
    private final SourceLocation sourceLoc;

    FieldAccessByIndexEvalFactory(IScalarEvaluatorFactory recordEvalFactory, IScalarEvaluatorFactory fieldIndexEvalFactory, ARecordType recordType, SourceLocation sourceLoc) {
        this.recordEvalFactory = recordEvalFactory;
        this.fieldIndexEvalFactory = fieldIndexEvalFactory;
        this.recordType = recordType;
        this.nullBitmapSize = recordType != null ? RecordUtil.computeNullBitmapSize((ARecordType)recordType) : 0;
        this.sourceLoc = sourceLoc;
    }

    public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
        return new IScalarEvaluator(){
            private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
            private final DataOutput out = this.resultStorage.getDataOutput();
            private final IPointable inputArg0 = new VoidPointable();
            private final IPointable inputArg1 = new VoidPointable();
            private final IScalarEvaluator eval0;
            private final IScalarEvaluator eval1;
            private int fieldIndex;
            private int fieldValueOffset;
            private int fieldValueLength;
            private IAType fieldValueType;
            private ATypeTag fieldValueTypeTag;
            {
                this.eval0 = FieldAccessByIndexEvalFactory.this.recordEvalFactory.createScalarEvaluator(ctx);
                this.eval1 = FieldAccessByIndexEvalFactory.this.fieldIndexEvalFactory.createScalarEvaluator(ctx);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                try {
                    this.resultStorage.reset();
                    this.eval0.evaluate(tuple, this.inputArg0);
                    this.eval1.evaluate(tuple, this.inputArg1);
                    if (PointableHelper.checkAndSetMissingOrNull(result, this.inputArg0, this.inputArg1)) {
                        return;
                    }
                    byte[] serRecord = this.inputArg0.getByteArray();
                    int offset = this.inputArg0.getStartOffset();
                    byte[] indexBytes = this.inputArg1.getByteArray();
                    int indexOffset = this.inputArg1.getStartOffset();
                    if (serRecord[offset] != ATypeTag.SERIALIZED_RECORD_TYPE_TAG || FieldAccessByIndexEvalFactory.this.recordType == null) {
                        throw new TypeMismatchException(FieldAccessByIndexEvalFactory.this.sourceLoc, serRecord[offset], ATypeTag.SERIALIZED_RECORD_TYPE_TAG);
                    }
                    if (indexBytes[indexOffset] != ATypeTag.SERIALIZED_INT32_TYPE_TAG) {
                        throw new TypeMismatchException(FieldAccessByIndexEvalFactory.this.sourceLoc, indexBytes[offset], ATypeTag.SERIALIZED_INT32_TYPE_TAG);
                    }
                    this.fieldIndex = IntegerPointable.getInteger((byte[])indexBytes, (int)(indexOffset + 1));
                    this.fieldValueType = FieldAccessByIndexEvalFactory.this.recordType.getFieldTypes()[this.fieldIndex];
                    this.fieldValueOffset = ARecordSerializerDeserializer.getFieldOffsetById((byte[])serRecord, (int)offset, (int)this.fieldIndex, (int)FieldAccessByIndexEvalFactory.this.nullBitmapSize, (boolean)FieldAccessByIndexEvalFactory.this.recordType.isOpen());
                    if (this.fieldValueOffset == 0) {
                        this.out.writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
                        result.set((IValueReference)this.resultStorage);
                        return;
                    }
                    if (this.fieldValueOffset < 0) {
                        this.out.writeByte(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
                        result.set((IValueReference)this.resultStorage);
                        return;
                    }
                    if (this.fieldValueType.getTypeTag().equals((Object)ATypeTag.UNION)) {
                        if (!((AUnionType)this.fieldValueType).isUnknownableType()) throw new NotImplementedException();
                        this.fieldValueTypeTag = ((AUnionType)this.fieldValueType).getActualType().getTypeTag();
                        this.fieldValueLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serRecord, (int)this.fieldValueOffset, (ATypeTag)this.fieldValueTypeTag, (boolean)false);
                        this.out.writeByte(this.fieldValueTypeTag.serialize());
                    } else {
                        this.fieldValueTypeTag = this.fieldValueType.getTypeTag();
                        this.fieldValueLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serRecord, (int)this.fieldValueOffset, (ATypeTag)this.fieldValueTypeTag, (boolean)false);
                        this.out.writeByte(this.fieldValueTypeTag.serialize());
                    }
                    this.out.write(serRecord, this.fieldValueOffset, this.fieldValueLength);
                    result.set((IValueReference)this.resultStorage);
                    return;
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }
        };
    }
}

