/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.fulltext;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.AbstractFullTextFilterEvaluator;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.FullTextFilterType;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IToken;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.TokenizerInfo;
import org.apache.hyracks.util.string.UTF8StringUtil;

public class StopwordsFullTextFilterEvaluator
extends AbstractFullTextFilterEvaluator {
    private final ImmutableList<String> stopwordList;

    public StopwordsFullTextFilterEvaluator(String name, ImmutableList<String> stopwordList) {
        super(name, FullTextFilterType.STOPWORDS);
        this.stopwordList = stopwordList;
    }

    public List<String> getStopwordList() {
        return this.stopwordList;
    }

    @Override
    public IToken processToken(TokenizerInfo.TokenizerType tokenizerType, IToken token) {
        String str;
        int start = token.getStartOffset();
        int length = token.getTokenLength();
        if (tokenizerType == TokenizerInfo.TokenizerType.LIST) {
            int numBytesToStoreLength = UTF8StringUtil.getNumBytesToStoreLength((int)UTF8StringUtil.getUTFLength((byte[])token.getData(), (int)token.getStartOffset()));
            start += numBytesToStoreLength;
            length -= numBytesToStoreLength;
        }
        if (this.stopwordList.contains((Object)(str = UTF8StringUtil.getUTF8StringInArray((byte[])token.getData(), (int)start, (int)length)))) {
            return null;
        }
        return token;
    }
}

