/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;

public class NumericBinaryToDoubleTypeComputer
extends AbstractResultTypeComputer {
    public static final NumericBinaryToDoubleTypeComputer INSTANCE = new NumericBinaryToDoubleTypeComputer();

    private NumericBinaryToDoubleTypeComputer() {
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        ATypeTag t0 = strippedInputTypes[0].getTypeTag();
        ATypeTag t1 = strippedInputTypes[1].getTypeTag();
        if (!NumericBinaryToDoubleTypeComputer.isValidType(t0) || !NumericBinaryToDoubleTypeComputer.isValidType(t1)) {
            return BuiltinType.ANULL;
        }
        return t0 == ATypeTag.ANY || t1 == ATypeTag.ANY ? AUnionType.createUnknownableType(BuiltinType.ADOUBLE) : BuiltinType.ADOUBLE;
    }

    private static boolean isValidType(ATypeTag tag) {
        return ATypeHierarchy.getTypeDomain(tag) == ATypeHierarchy.Domain.NUMERIC || tag == ATypeTag.ANY;
    }
}

