/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.row.generator;

import com.teradata.tpcds.JoinKeyUtils;
import com.teradata.tpcds.Nulls;
import com.teradata.tpcds.Permutations;
import com.teradata.tpcds.Scaling;
import com.teradata.tpcds.Session;
import com.teradata.tpcds.SlowlyChangingDimensionUtils;
import com.teradata.tpcds.Table;
import com.teradata.tpcds.generator.WebSalesGeneratorColumn;
import com.teradata.tpcds.random.RandomValueGenerator;
import com.teradata.tpcds.row.TableRow;
import com.teradata.tpcds.row.WebReturnsRow;
import com.teradata.tpcds.row.WebSalesRow;
import com.teradata.tpcds.row.generator.AbstractRowGenerator;
import com.teradata.tpcds.row.generator.RowGenerator;
import com.teradata.tpcds.row.generator.RowGeneratorResult;
import com.teradata.tpcds.row.generator.WebReturnsRowGenerator;
import com.teradata.tpcds.type.Pricing;
import java.util.ArrayList;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class WebSalesRowGenerator
extends AbstractRowGenerator {
    public static final int GIFT_PERCENTAGE = 7;
    public static final int RETURN_PERCENTAGE = 10;
    private int[] itemPermutation = null;
    private int remainingLineItems = 0;
    private OrderInfo orderInfo;
    private int itemIndex;

    public WebSalesRowGenerator() {
        super(Table.WEB_SALES);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        Scaling scaling = session.getScaling();
        int itemCount = (int)scaling.getIdCount(Table.ITEM);
        if (this.itemPermutation == null) {
            this.itemPermutation = Permutations.makePermutation(itemCount, this.getRandomNumberStream(WebSalesGeneratorColumn.WS_PERMUTATION));
        }
        if (this.remainingLineItems == 0) {
            this.orderInfo = this.generateOrderInfo(rowNumber, session);
            this.itemIndex = RandomValueGenerator.generateUniformRandomInt(1, itemCount, this.getRandomNumberStream(WebSalesGeneratorColumn.WS_ITEM_SK));
            this.remainingLineItems = RandomValueGenerator.generateUniformRandomInt(8, 16, this.getRandomNumberStream(WebSalesGeneratorColumn.WS_ORDER_NUMBER));
        }
        long nullBitMap = Nulls.createNullBitMap(Table.WEB_SALES, this.getRandomNumberStream(WebSalesGeneratorColumn.WS_NULLS));
        int shipLag = RandomValueGenerator.generateUniformRandomInt(1, 120, this.getRandomNumberStream(WebSalesGeneratorColumn.WS_SHIP_DATE_SK));
        long wsShipDateSk = this.orderInfo.wsSoldDateSk + (long)shipLag;
        if (++this.itemIndex > itemCount) {
            this.itemIndex = 1;
        }
        long wsItemSk = SlowlyChangingDimensionUtils.matchSurrogateKey(Permutations.getPermutationEntry(this.itemPermutation, this.itemIndex), this.orderInfo.wsSoldDateSk, Table.ITEM, scaling);
        long wsWebPageSk = JoinKeyUtils.generateJoinKey(WebSalesGeneratorColumn.WS_WEB_PAGE_SK, this.getRandomNumberStream(WebSalesGeneratorColumn.WS_WEB_PAGE_SK), Table.WEB_PAGE, this.orderInfo.wsSoldDateSk, scaling);
        long wsWebSiteSk = JoinKeyUtils.generateJoinKey(WebSalesGeneratorColumn.WS_WEB_SITE_SK, this.getRandomNumberStream(WebSalesGeneratorColumn.WS_WEB_SITE_SK), Table.WEB_SITE, this.orderInfo.wsSoldDateSk, scaling);
        long wsShipModeSk = JoinKeyUtils.generateJoinKey(WebSalesGeneratorColumn.WS_SHIP_MODE_SK, this.getRandomNumberStream(WebSalesGeneratorColumn.WS_SHIP_MODE_SK), Table.SHIP_MODE, 1L, scaling);
        long wsWarehouseSk = JoinKeyUtils.generateJoinKey(WebSalesGeneratorColumn.WS_WAREHOUSE_SK, this.getRandomNumberStream(WebSalesGeneratorColumn.WS_WAREHOUSE_SK), Table.WAREHOUSE, 1L, scaling);
        long wsPromoSk = JoinKeyUtils.generateJoinKey(WebSalesGeneratorColumn.WS_PROMO_SK, this.getRandomNumberStream(WebSalesGeneratorColumn.WS_PROMO_SK), Table.PROMOTION, 1L, scaling);
        Pricing wsPricing = Pricing.generatePricingForSalesTable(WebSalesGeneratorColumn.WS_PRICING, this.getRandomNumberStream(WebSalesGeneratorColumn.WS_PRICING));
        WebSalesRow salesRow = new WebSalesRow(nullBitMap, this.orderInfo.wsSoldDateSk, this.orderInfo.wsSoldTimeSk, wsShipDateSk, wsItemSk, this.orderInfo.wsBillCustomerSk, this.orderInfo.wsBillCdemoSk, this.orderInfo.wsBillHdemoSk, this.orderInfo.wsBillAddrSk, this.orderInfo.wsShipCustomerSk, this.orderInfo.wsShipCdemoSk, this.orderInfo.wsShipHdemoSk, this.orderInfo.wsShipAddrSk, wsWebPageSk, wsWebSiteSk, wsShipModeSk, wsWarehouseSk, wsPromoSk, this.orderInfo.wsOrderNumber, wsPricing);
        ArrayList<TableRow> generatedRows = new ArrayList<TableRow>(2);
        generatedRows.add(salesRow);
        int randomInt = RandomValueGenerator.generateUniformRandomInt(0, 99, this.getRandomNumberStream(WebSalesGeneratorColumn.WR_IS_RETURNED));
        if (!(randomInt >= 10 || session.generateOnlyOneTable() && session.getOnlyTableToGenerate() == Table.WEB_SALES)) {
            WebReturnsRow returnsRow = ((WebReturnsRowGenerator)childRowGenerator).generateRow(session, salesRow);
            generatedRows.add(returnsRow);
        }
        --this.remainingLineItems;
        return new RowGeneratorResult(generatedRows, this.remainingLineItems == 0);
    }

    private OrderInfo generateOrderInfo(long rowNumber, Session session) {
        Scaling scaling = session.getScaling();
        long wsSoldDateSk = JoinKeyUtils.generateJoinKey(WebSalesGeneratorColumn.WS_SOLD_DATE_SK, this.getRandomNumberStream(WebSalesGeneratorColumn.WS_SOLD_DATE_SK), Table.DATE_DIM, 1L, scaling);
        long wsSoldTimeSk = JoinKeyUtils.generateJoinKey(WebSalesGeneratorColumn.WS_SOLD_TIME_SK, this.getRandomNumberStream(WebSalesGeneratorColumn.WS_SOLD_TIME_SK), Table.TIME_DIM, 1L, scaling);
        long wsBillCustomerSk = JoinKeyUtils.generateJoinKey(WebSalesGeneratorColumn.WS_BILL_CUSTOMER_SK, this.getRandomNumberStream(WebSalesGeneratorColumn.WS_BILL_CUSTOMER_SK), Table.CUSTOMER, 1L, scaling);
        long wsBillCdemoSk = JoinKeyUtils.generateJoinKey(WebSalesGeneratorColumn.WS_BILL_CDEMO_SK, this.getRandomNumberStream(WebSalesGeneratorColumn.WS_BILL_CDEMO_SK), Table.CUSTOMER_DEMOGRAPHICS, 1L, scaling);
        long wsBillHdemoSk = JoinKeyUtils.generateJoinKey(WebSalesGeneratorColumn.WS_BILL_HDEMO_SK, this.getRandomNumberStream(WebSalesGeneratorColumn.WS_BILL_HDEMO_SK), Table.HOUSEHOLD_DEMOGRAPHICS, 1L, scaling);
        long wsBillAddrSk = JoinKeyUtils.generateJoinKey(WebSalesGeneratorColumn.WS_BILL_ADDR_SK, this.getRandomNumberStream(WebSalesGeneratorColumn.WS_BILL_ADDR_SK), Table.CUSTOMER_ADDRESS, 1L, scaling);
        long wsShipCustomerSk = wsBillCustomerSk;
        long wsShipCdemoSk = wsBillCdemoSk;
        long wsShipHdemoSK = wsBillHdemoSk;
        long wsShipAddrSk = wsBillAddrSk;
        int randomInt = RandomValueGenerator.generateUniformRandomInt(0, 99, this.getRandomNumberStream(WebSalesGeneratorColumn.WS_SHIP_CUSTOMER_SK));
        if (randomInt > 7) {
            wsShipCustomerSk = JoinKeyUtils.generateJoinKey(WebSalesGeneratorColumn.WS_SHIP_CUSTOMER_SK, this.getRandomNumberStream(WebSalesGeneratorColumn.WS_SHIP_CUSTOMER_SK), Table.CUSTOMER, 2L, scaling);
            wsShipCdemoSk = JoinKeyUtils.generateJoinKey(WebSalesGeneratorColumn.WS_SHIP_CDEMO_SK, this.getRandomNumberStream(WebSalesGeneratorColumn.WS_SHIP_CDEMO_SK), Table.CUSTOMER_DEMOGRAPHICS, 2L, scaling);
            wsShipHdemoSK = JoinKeyUtils.generateJoinKey(WebSalesGeneratorColumn.WS_SHIP_HDEMO_SK, this.getRandomNumberStream(WebSalesGeneratorColumn.WS_SHIP_HDEMO_SK), Table.HOUSEHOLD_DEMOGRAPHICS, 2L, scaling);
            wsShipAddrSk = JoinKeyUtils.generateJoinKey(WebSalesGeneratorColumn.WS_SHIP_ADDR_SK, this.getRandomNumberStream(WebSalesGeneratorColumn.WS_SHIP_ADDR_SK), Table.CUSTOMER_ADDRESS, 2L, scaling);
        }
        long wsOrderNumber = rowNumber;
        return new OrderInfo(wsSoldDateSk, wsSoldTimeSk, wsBillCustomerSk, wsBillCdemoSk, wsBillHdemoSk, wsBillAddrSk, wsShipCustomerSk, wsShipCdemoSk, wsShipHdemoSK, wsShipAddrSk, wsOrderNumber);
    }

    private static class OrderInfo {
        private final long wsSoldDateSk;
        private final long wsSoldTimeSk;
        private final long wsBillCustomerSk;
        private final long wsBillCdemoSk;
        private final long wsBillHdemoSk;
        private final long wsBillAddrSk;
        private final long wsShipCustomerSk;
        private final long wsShipCdemoSk;
        private final long wsShipHdemoSk;
        private final long wsShipAddrSk;
        private final long wsOrderNumber;

        public OrderInfo(long wsSoldDateSk, long wsSoldTimeSk, long wsBillCustomerSk, long wsBillCdemoSk, long wsBillHdemoSk, long wsBillAddrSk, long wsShipCustomerSk, long wsShipCdemoSk, long wsShipHdemoSk, long wsShipAddrSk, long wsOrderNumber) {
            this.wsSoldDateSk = wsSoldDateSk;
            this.wsSoldTimeSk = wsSoldTimeSk;
            this.wsBillCustomerSk = wsBillCustomerSk;
            this.wsBillCdemoSk = wsBillCdemoSk;
            this.wsBillHdemoSk = wsBillHdemoSk;
            this.wsBillAddrSk = wsBillAddrSk;
            this.wsShipCustomerSk = wsShipCustomerSk;
            this.wsShipCdemoSk = wsShipCdemoSk;
            this.wsShipHdemoSk = wsShipHdemoSk;
            this.wsShipAddrSk = wsShipAddrSk;
            this.wsOrderNumber = wsOrderNumber;
        }
    }
}

