/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.utils;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import org.apache.asterix.runtime.evaluators.functions.StringEvaluatorUtils;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleOutputStream;
import org.apache.hyracks.data.std.util.GrowableArray;
import org.apache.hyracks.data.std.util.UTF8StringBuilder;

public class StringTrimmer {
    private final ByteArrayAccessibleOutputStream lastPatternStorage = new ByteArrayAccessibleOutputStream();
    private final UTF8StringPointable lastPatternPtr = new UTF8StringPointable();
    private IntSet codePointSet = new IntArraySet();
    private final UTF8StringBuilder resultBuilder;
    private final GrowableArray resultArray;

    public StringTrimmer(UTF8StringBuilder resultBuilder, GrowableArray resultArray) {
        this(resultBuilder, resultArray, null);
    }

    public StringTrimmer(UTF8StringBuilder resultBuilder, GrowableArray resultArray, UTF8StringPointable pattern) {
        this.resultBuilder = resultBuilder;
        this.resultArray = resultArray;
        if (pattern != null) {
            this.codePointSet.clear();
            pattern.getCodePoints((IntCollection)this.codePointSet);
        }
    }

    public void build(UTF8StringPointable patternPtr) {
        boolean newPattern;
        boolean bl = newPattern = this.codePointSet.size() == 0 || this.lastPatternPtr.compareTo((IPointable)patternPtr) != 0;
        if (newPattern) {
            StringEvaluatorUtils.copyResetUTF8Pointable(patternPtr, this.lastPatternStorage, this.lastPatternPtr);
            this.codePointSet.clear();
            patternPtr.getCodePoints((IntCollection)this.codePointSet);
        }
    }

    public void trim(UTF8StringPointable srcPtr, IPointable resultStrPtr, boolean left, boolean right) throws IOException {
        srcPtr.trim(this.resultBuilder, this.resultArray, left, right, (IntCollection)this.codePointSet);
        resultStrPtr.set(this.resultArray.getByteArray(), 0, this.resultArray.getLength());
    }
}

