/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.job;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.job.IJobSerializerDeserializer;
import org.apache.hyracks.api.job.IJobSerializerDeserializerContainer;
import org.apache.hyracks.api.job.JobSerializerDeserializer;

public class JobSerializerDeserializerContainer
implements IJobSerializerDeserializerContainer {
    private IJobSerializerDeserializer defaultJobSerDe = new JobSerializerDeserializer();
    private Map<DeploymentId, IJobSerializerDeserializer> jobSerializerDeserializerMap = new ConcurrentHashMap<DeploymentId, IJobSerializerDeserializer>();

    @Override
    public synchronized IJobSerializerDeserializer getJobSerializerDeserializer(DeploymentId deploymentId) {
        if (deploymentId == null) {
            return this.defaultJobSerDe;
        }
        IJobSerializerDeserializer jobSerDe = this.jobSerializerDeserializerMap.get(deploymentId);
        return jobSerDe;
    }

    @Override
    public synchronized void addJobSerializerDeserializer(DeploymentId deploymentId, IJobSerializerDeserializer jobSerDe) {
        this.jobSerializerDeserializerMap.put(deploymentId, jobSerDe);
    }

    @Override
    public synchronized void removeJobSerializerDeserializer(DeploymentId deploymentId) {
        this.jobSerializerDeserializerMap.remove(deploymentId);
    }

    public String toString() {
        return this.jobSerializerDeserializerMap.toString();
    }
}

