/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.operators;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.asterix.common.library.LibraryDescriptor;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.external.operators.AbstractLibraryOperatorDescriptor;
import org.apache.asterix.external.util.ExternalLibraryUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.util.file.FileUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LibraryDeployPrepareOperatorDescriptor
extends AbstractLibraryOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(LibraryDeployPrepareOperatorDescriptor.class);
    private final ExternalFunctionLanguage language;
    private final URI libLocation;
    private final String authToken;

    public LibraryDeployPrepareOperatorDescriptor(IOperatorDescriptorRegistry spec, DataverseName dataverseName, String libraryName, ExternalFunctionLanguage language, URI libLocation, String authToken) {
        super(spec, dataverseName, libraryName);
        this.language = language;
        this.libLocation = libLocation;
        this.authToken = authToken;
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) {
        return new AbstractLibraryOperatorDescriptor.AbstractLibraryNodePushable(ctx){
            private final byte[] copyBuf;
            {
                this.copyBuf = new byte[4096];
            }

            @Override
            protected void execute() throws IOException {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Prepare deployment of library {}.{}", (Object)LibraryDeployPrepareOperatorDescriptor.this.dataverseName, (Object)LibraryDeployPrepareOperatorDescriptor.this.libraryName);
                }
                FileReference libDir = this.getLibraryDir();
                Path libDirPath = libDir.getFile().toPath();
                FileReference stage = this.getStageDir();
                if (Files.isDirectory(libDirPath, new LinkOption[0])) {
                    this.dropIfExists(stage);
                } else {
                    this.dropIfExists(libDir);
                    FileUtil.forceMkdirs((File)libDir.getFile());
                    Path dataverseDir = libDirPath.getParent();
                    this.flushDirectory(dataverseDir);
                    this.flushDirectory(dataverseDir.getParent());
                }
                this.mkdir(stage);
                this.fetch(stage);
                this.closeLibrary();
                FileReference rev1 = this.getRev1Dir();
                if (rev1.getFile().exists()) {
                    FileReference rev0 = this.getRev0Dir();
                    this.move(rev1, rev0);
                }
                this.flushDirectory(libDir);
            }

            private void fetch(FileReference stageDir) throws IOException {
                String libLocationPath = LibraryDeployPrepareOperatorDescriptor.this.libLocation.getPath();
                String fileExt = FilenameUtils.getExtension((String)libLocationPath);
                FileReference targetFile = stageDir.getChild("lib." + fileExt);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Downloading library from {} into {}", (Object)LibraryDeployPrepareOperatorDescriptor.this.libLocation, (Object)targetFile);
                }
                MessageDigest digest = this.libraryManager.download(targetFile, LibraryDeployPrepareOperatorDescriptor.this.authToken, LibraryDeployPrepareOperatorDescriptor.this.libLocation);
                FileReference contentsDir = stageDir.getChild("contents");
                this.mkdir(contentsDir);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Extracting library from {} into {}", (Object)targetFile, (Object)contentsDir);
                }
                switch (LibraryDeployPrepareOperatorDescriptor.this.language) {
                    case JAVA: {
                        this.libraryManager.unzip(targetFile, contentsDir);
                        break;
                    }
                    case PYTHON: {
                        boolean extractMsgPack = this.ctx.getJobletContext().getServiceContext().getAppConfig().getBoolean((IOption)NCConfig.Option.PYTHON_USE_BUNDLED_MSGPACK);
                        this.shiv(targetFile, stageDir, contentsDir, extractMsgPack);
                        break;
                    }
                    default: {
                        throw new IOException("Unexpected language: " + LibraryDeployPrepareOperatorDescriptor.this.language);
                    }
                }
                FileReference targetDescFile = stageDir.getChild("lib.json");
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Writing library descriptor into {}", (Object)targetDescFile);
                }
                this.writeDescriptor(targetDescFile, new LibraryDescriptor(LibraryDeployPrepareOperatorDescriptor.this.language, ExternalLibraryUtils.digestToHexString(digest)));
                this.flushDirectory(contentsDir);
                this.flushDirectory(stageDir);
            }

            private void shiv(FileReference sourceFile, FileReference stageDir, FileReference contentsDir, boolean writeMsgpack) throws IOException {
                FileReference msgpack = stageDir.getChild("msgpack.pyz");
                if (writeMsgpack) {
                    this.writeShim(msgpack);
                    File msgPackFolder = new File(contentsDir.getRelativePath(), "ipc");
                    FileReference msgPackFolderRef = new FileReference(contentsDir.getDeviceHandle(), msgPackFolder.getPath());
                    this.libraryManager.unzip(msgpack, msgPackFolderRef);
                    Files.delete(msgpack.getFile().toPath());
                }
                this.libraryManager.unzip(sourceFile, contentsDir);
                this.writeShim(contentsDir.getChild("entrypoint.py"));
            }

            private void writeShim(FileReference outputFile) throws IOException {
                InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(outputFile.getFile().getName());
                if (is == null) {
                    throw new IOException("Classpath does not contain necessary Python resources!");
                }
                try {
                    this.libraryManager.writeAndForce(outputFile, is, this.copyBuf);
                }
                finally {
                    is.close();
                }
            }

            private void writeDescriptor(FileReference descFile, LibraryDescriptor desc) throws IOException {
                byte[] bytes = this.libraryManager.serializeLibraryDescriptor(desc);
                this.libraryManager.writeAndForce(descFile, (InputStream)new ByteArrayInputStream(bytes), this.copyBuf);
            }
        };
    }
}

