/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.parser.ParseException;
import org.apache.asterix.lang.sqlpp.util.ExpressionToVariableUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class GenerateColumnNameVisitor
extends AbstractSqlppExpressionScopingVisitor {
    private final Map<Expression, VarIdentifier> gbyKeyExprMap = new HashMap<Expression, VarIdentifier>();
    private final Set<VarIdentifier> gbyKeyVars = new HashSet<VarIdentifier>();

    public GenerateColumnNameVisitor(LangRewritingContext context) {
        super(context);
    }

    @Override
    public Expression visit(SelectBlock selectBlock, ILangExpression arg) throws CompilationException {
        selectBlock.getSelectClause().accept(this, arg);
        return super.visit(selectBlock, arg);
    }

    @Override
    public Expression visit(Projection projection, ILangExpression arg) throws CompilationException {
        if (!projection.star() && !projection.varStar() && projection.getName() == null) {
            projection.setName(SqlppVariableUtil.variableNameToDisplayedFieldName(this.context.newVariable().getValue()));
        }
        return super.visit(projection, arg);
    }

    @Override
    public Expression visit(GroupbyClause groupbyClause, ILangExpression arg) throws CompilationException {
        this.gbyKeyExprMap.clear();
        this.gbyKeyVars.clear();
        for (List gbyPairList : groupbyClause.getGbyPairList()) {
            for (GbyVariableExpressionPair gbyKeyPair : gbyPairList) {
                if (gbyKeyPair.getVar() == null) {
                    VariableExpr varExpr;
                    Expression gbyKeyExpr = gbyKeyPair.getExpr();
                    SourceLocation sourceLoc = gbyKeyExpr.getSourceLocation();
                    VarIdentifier varId = this.gbyKeyExprMap.get(gbyKeyExpr);
                    if (varId == null) {
                        try {
                            varExpr = ExpressionToVariableUtil.getGeneratedVariable(gbyKeyExpr, false);
                        }
                        catch (ParseException e) {
                            throw new CompilationException(ErrorCode.PARSE_ERROR, (Throwable)e, sourceLoc, new Serializable[0]);
                        }
                        if (varExpr == null || this.gbyKeyVars.contains(varExpr.getVar())) {
                            varExpr = new VariableExpr(this.context.newVariable());
                        }
                        this.gbyKeyExprMap.put(gbyKeyExpr, varExpr.getVar());
                    } else {
                        varExpr = new VariableExpr(varId);
                    }
                    varExpr.setSourceLocation(sourceLoc);
                    gbyKeyPair.setVar(varExpr);
                }
                this.gbyKeyVars.add(gbyKeyPair.getVar().getVar());
            }
        }
        return super.visit(groupbyClause, arg);
    }
}

