/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.net.ssl.SSLException;
import org.ietf.jgss.GSSException;

public class GlobusGSSException
extends GSSException {
    private static final long serialVersionUID = 1366868883920091438L;
    public static final int PROXY_VIOLATION = 5;
    public static final int BAD_ARGUMENT = 7;
    public static final int BAD_NAME = 25;
    public static final int CREDENTIAL_ERROR = 27;
    public static final int TOKEN_FAIL = 29;
    public static final int DELEGATION_ERROR = 30;
    public static final int BAD_MIC = 33;
    public static final int UNKNOWN_OPTION = 37;
    public static final int BAD_OPTION_TYPE = 100;
    public static final int BAD_OPTION = 101;
    public static final int UNKNOWN = 102;
    private static ResourceBundle resources;
    private final boolean hasCustomMessage;

    public GlobusGSSException(int majorCode, Throwable cause) {
        super(majorCode);
        this.initCause(cause);
        this.hasCustomMessage = false;
    }

    public GlobusGSSException(int majorCode, int minorCode, String minorString, Throwable cause) {
        super(majorCode, minorCode, minorString);
        this.initCause(cause);
        this.hasCustomMessage = true;
    }

    public GlobusGSSException(int majorCode, int minorCode, String key) {
        this(majorCode, minorCode, key, (Object[])null);
    }

    public GlobusGSSException(int majorCode, int minorCode, String key, Object[] args) {
        super(majorCode);
        String msg = null;
        try {
            msg = MessageFormat.format(resources.getString(key), args);
        }
        catch (MissingResourceException e) {
            throw new RuntimeException("bad" + key);
        }
        this.setMinor(minorCode, msg);
        this.initCause(null);
        this.hasCustomMessage = true;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream ps) {
        if (this.getCause() != null) {
            String superString = this.getLocalMessage();
            PrintStream printStream = ps;
            synchronized (printStream) {
                ps.print(superString);
                ps.print(superString.endsWith(".") ? " Caused by " : ". Caused by ");
                this.getCause().printStackTrace(ps);
            }
        } else {
            super.printStackTrace(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter pw) {
        if (this.getCause() != null) {
            String superString = this.getLocalMessage();
            PrintWriter printWriter = pw;
            synchronized (printWriter) {
                pw.print(superString);
                pw.print(superString.endsWith(".") ? " Caused by " : ". Caused by ");
                this.getCause().printStackTrace(pw);
            }
        } else {
            super.printStackTrace(pw);
        }
    }

    public String getMessage() {
        Throwable cause = this.getCause();
        if (GlobusGSSException.isBoring(this)) {
            return GlobusGSSException.getUsefulMessage(cause);
        }
        StringBuilder message = new StringBuilder(super.getMessage());
        if (cause != null) {
            message.append(" [Caused by: ").append(GlobusGSSException.getUsefulMessage(cause)).append("]");
        }
        return message.toString();
    }

    private static String getUsefulMessage(Throwable throwable) {
        while (GlobusGSSException.isBoring(throwable)) {
            throwable = throwable.getCause();
        }
        String message = throwable.getMessage();
        if (message == null) {
            message = throwable.getClass().getName();
        }
        return message;
    }

    private static boolean isBoring(Throwable t) {
        GlobusGSSException g;
        if (t.getCause() == null) {
            return false;
        }
        if (t instanceof GSSException && (g = (GlobusGSSException)t).getMajor() == 11 && g.getMinor() == 0) {
            if (g instanceof GlobusGSSException) {
                return !g.hasCustomMessage;
            }
            return ((GSSException)g).getMessage().equals("Failure unspecified at GSS-API level");
        }
        return t instanceof SSLException && t.getMessage().equals("General SSLEngine problem");
    }

    private String getLocalMessage() {
        String message = super.getMessage();
        return message == null ? this.getClass().getName() : message;
    }

    static {
        try {
            resources = ResourceBundle.getBundle("org.globus.gsi.gssapi.errors");
        }
        catch (MissingResourceException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

