/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util.httpclient;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.unicore.security.canl.SSLContextCreator;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.CanlHostnameVerifier;
import eu.unicore.util.httpclient.HttpClientProperties;
import eu.unicore.util.httpclient.IClientConfiguration;
import eu.unicore.util.httpclient.IPlainClientConfiguration;
import eu.unicore.util.httpclient.VeryLaxRedirectStrategy;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.NTLMSchemeFactory;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;

public class HttpUtils {
    private static final Logger logger = Log.getLogger("unicore.client", HttpUtils.class);
    private static final ConnectionCloseInterceptor CONN_CLOSE_INTERCEPTOR = new ConnectionCloseInterceptor();
    public static final String USER_AGENT = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)";

    private HttpUtils() {
    }

    public static synchronized HttpClient createClient(String uri, IClientConfiguration security) {
        DefaultHttpClient client = HttpUtils.createClient(security.getHttpClientProperties());
        if (security.isSslEnabled()) {
            HttpUtils.configureSSL(client, security);
        }
        HttpUtils.configureProxy(client, uri, security.getHttpClientProperties());
        return client;
    }

    @Deprecated
    public static synchronized DefaultHttpClient createClient(Properties properties) {
        HttpClientProperties parsed = new HttpClientProperties(properties);
        return HttpUtils.createClient(parsed);
    }

    public static synchronized DefaultHttpClient createClient(HttpClientProperties properties) {
        boolean connClose = properties.getBooleanValue("connection-close");
        boolean allowCircularRedirects = properties.getBooleanValue("allowCircularRedirects");
        int maxRedirects = properties.getIntValue("maxRedirects");
        PoolingClientConnectionManager manager = new PoolingClientConnectionManager();
        int maxConnPerHost = properties.getIntValue("maxPerRoute");
        manager.setDefaultMaxPerRoute(maxConnPerHost);
        int maxTotalConn = properties.getIntValue("maxTotal");
        manager.setMaxTotal(maxTotalConn);
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)manager);
        client.setRedirectStrategy((RedirectStrategy)new VeryLaxRedirectStrategy());
        HttpParams params = client.getParams();
        params.setParameter("http.useragent", (Object)USER_AGENT);
        params.setBooleanParameter("http.protocol.max-redirects", true);
        params.setIntParameter("http.protocol.max-redirects", maxRedirects);
        params.setBooleanParameter("http.protocol.allow-circular-redirects", allowCircularRedirects);
        if (connClose) {
            client.addRequestInterceptor((HttpRequestInterceptor)CONN_CLOSE_INTERCEPTOR);
        }
        int socketTimeout = properties.getIntValue("socket.timeout");
        int connectTimeout = properties.getIntValue("connection.timeout");
        HttpUtils.setConnectionTimeout((HttpClient)client, socketTimeout, connectTimeout);
        return client;
    }

    public static void configureSSL(DefaultHttpClient client, IClientConfiguration security) {
        SchemeRegistry schemeRegistry = client.getConnectionManager().getSchemeRegistry();
        SSLContext sslContext = HttpUtils.createSSLContext(security);
        CanlHostnameVerifier hostnameVerifier = new CanlHostnameVerifier(security.getServerHostnameCheckingMode());
        SSLSocketFactory schemeSocketFactory = new SSLSocketFactory(sslContext, (X509HostnameVerifier)hostnameVerifier);
        Scheme sslScheme = new Scheme("https", 443, (SchemeSocketFactory)schemeSocketFactory);
        schemeRegistry.register(sslScheme);
    }

    public static void configureProxy(DefaultHttpClient client, String uri, HttpClientProperties properties) {
        if (HttpUtils.isNonProxyHost(uri, properties)) {
            return;
        }
        String proxyHost = properties.getValue("proxyHost");
        if (proxyHost == null) {
            proxyHost = System.getProperty("proxyHost");
        }
        if (proxyHost != null && proxyHost.trim().length() > 0) {
            String portS;
            Integer port = properties.getIntValue("proxyPort");
            if (port == null && (portS = System.getProperty("proxyPort")) != null) {
                port = Integer.parseInt(portS);
            }
            if (port == null) {
                port = 80;
            }
            HttpHost proxy = new HttpHost(proxyHost, port.intValue());
            client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            String proxyUser = properties.getValue("proxy.user");
            String proxyPass = properties.getValue("proxy.password");
            if (proxyUser != null && proxyPass != null) {
                Credentials credentials = HttpUtils.getCredentials(proxyUser, proxyPass);
                client.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, port.intValue()), credentials);
                boolean ntlm = credentials instanceof NTCredentials;
                client.addRequestInterceptor((HttpRequestInterceptor)new ProxyPreemptiveAuthnInterceptor(proxy, ntlm));
            }
        }
    }

    private static boolean isNonProxyHost(String uri, HttpClientProperties properties) {
        String nonProxyHosts = properties.getValue("nonProxyHosts");
        if (nonProxyHosts == null) {
            return false;
        }
        try {
            String[] npHosts;
            URI u = new URI(uri);
            String host = u.getHost();
            for (String npHost : npHosts = nonProxyHosts.split(" ")) {
                if (!host.contains(npHost)) continue;
                return true;
            }
        }
        catch (URISyntaxException e) {
            logger.error("Can't resolve URI from " + uri, e);
        }
        return false;
    }

    private static Credentials getCredentials(String username, String password) {
        int domainIndex = username.indexOf(92);
        if (domainIndex > 0 && username.length() > domainIndex + 1) {
            return new NTCredentials(username.substring(0, domainIndex), password, "localhost", username.substring(domainIndex + 1));
        }
        return new UsernamePasswordCredentials(username, password);
    }

    public static void setConnectionTimeout(HttpClient client, int socketTimeout, int connectTimeout) {
        client.getParams().setIntParameter("http.socket.timeout", socketTimeout);
        client.getParams().setLongParameter("http.conn-manager.timeout", (long)connectTimeout);
        client.getParams().setIntParameter("http.connection.timeout", connectTimeout);
    }

    private static SSLContext createSSLContext(IPlainClientConfiguration sec) {
        X509Credential credential = sec.doSSLAuthn() ? sec.getCredential() : null;
        try {
            return SSLContextCreator.createSSLContext(credential, (X509CertChainValidator)sec.getValidator(), "TLS", "HTTP Client", logger);
        }
        catch (Exception e) {
            logger.fatal(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    private static class ProxyPreemptiveAuthnInterceptor
    implements HttpRequestInterceptor {
        private HttpHost host;
        private boolean ntlm;

        public ProxyPreemptiveAuthnInterceptor(HttpHost host, boolean ntlm) {
            this.host = host;
            this.ntlm = ntlm;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
            if (authCache == null) {
                authCache = new BasicAuthCache();
                context.setAttribute("http.auth.auth-cache", (Object)authCache);
            }
            if (authCache.get(this.host) == null) {
                BasicScheme scheme = this.ntlm ? new NTLMSchemeFactory().newInstance(null) : new BasicScheme();
                authCache.put(this.host, (AuthScheme)scheme);
            }
        }
    }

    private static class ConnectionCloseInterceptor
    implements HttpRequestInterceptor {
        private ConnectionCloseInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.setHeader("Connection", "close");
        }
    }
}

