/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.server;

import eu.unicore.uftp.dpc.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.concurrent.TimeUnit;

public class FileWatcher
implements Runnable {
    private final File target;
    private final Runnable action;
    private long lastAccessed;

    public FileWatcher(File target, Runnable action) throws FileNotFoundException {
        if (!target.exists() || !target.canRead()) {
            throw new FileNotFoundException("File " + target.getAbsolutePath() + " does not exist or is not readable.");
        }
        this.target = target;
        this.action = action;
        this.lastAccessed = target.lastModified();
    }

    public void schedule(int delay, TimeUnit timeunit) {
        Utils.getExecutor().scheduleWithFixedDelay(this, delay, delay, timeunit);
    }

    @Override
    public void run() {
        if (this.target.lastModified() > this.lastAccessed) {
            this.lastAccessed = this.target.lastModified();
            this.action.run();
        }
    }
}

