/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.server;

import eu.unicore.uftp.dpc.AuthorizationFailureException;
import eu.unicore.uftp.server.FileWatcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;

public class ACLHandler {
    private static final Logger logger = Logger.getLogger(ACLHandler.class);
    private final File aclFile;
    private final FileWatcher watchDog;
    private final boolean active;
    private final Set<String> acceptedDNs = new HashSet<String>();

    public ACLHandler() throws IOException {
        this(new File("conf", "uftpd.acl"));
    }

    public ACLHandler(File aclFile) throws IOException {
        this.aclFile = aclFile;
        if (!aclFile.exists()) {
            logger.warn("ACL not active: file <" + aclFile + "> does not exist");
            this.active = false;
            this.watchDog = null;
            return;
        }
        this.active = true;
        logger.info("Using ACL file " + aclFile);
        this.readACL();
        this.watchDog = new FileWatcher(aclFile, new Runnable(){

            @Override
            public void run() {
                ACLHandler.this.readACL();
            }
        });
        this.watchDog.schedule(3000, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readACL() {
        Set<String> set = this.acceptedDNs;
        synchronized (set) {
            BufferedReader br = null;
            try {
                String theLine;
                br = new BufferedReader(new FileReader(this.aclFile));
                this.acceptedDNs.clear();
                while ((theLine = br.readLine()) != null) {
                    String line = theLine.trim();
                    if (line.startsWith("#") || line.trim().equals("")) continue;
                    try {
                        X500Principal p = new X500Principal(line);
                        this.acceptedDNs.add(p.getName());
                        logger.info("Allowing access for <" + line + ">");
                    }
                    catch (Exception ex) {
                        logger.warn("Invalid entry <" + line + ">", ex);
                    }
                }
            }
            catch (Exception ex) {
                logger.fatal("ACL file read error!", ex);
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAccess(String userName) throws AuthorizationFailureException {
        if (!this.active) {
            return;
        }
        logger.debug("Check access from " + userName);
        Set<String> set = this.acceptedDNs;
        synchronized (set) {
            if (!this.acceptedDNs.contains(userName)) {
                String msg = "Access denied!\n\nTo allow access for this certificate, the distinguished name \n\"" + userName + "\nneeds to be entered into the ACL file." + "\nPlease check the UFTPD's ACL file!\n\n";
                throw new AuthorizationFailureException(msg);
            }
        }
    }
}

