/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.security;

import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import eu.unicore.security.wsutil.client.authn.CachingIdentityResolver;
import java.io.IOException;
import org.oasisOpen.docs.wsrf.sg2.EntryType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class RegistryIdentityResolver
extends CachingIdentityResolver {
    private IRegistryQuery registry;

    public RegistryIdentityResolver(IRegistryQuery registry) {
        this.registry = registry;
    }

    @Override
    public synchronized String resolveIdentity(String serviceURL) throws IOException {
        try {
            return super.resolveIdentity(serviceURL);
        }
        catch (IOException e) {
            return this.searchInRegistry(serviceURL);
        }
    }

    private String searchInRegistry(String url) throws IOException {
        String container = this.getContainerAddress(url);
        try {
            for (EntryType entry : this.registry.listEntries()) {
                String dn;
                EndpointReferenceType memberEpr = entry.getMemberServiceEPR();
                if (!memberEpr.getAddress().getStringValue().startsWith(container) || (dn = WSUtilities.extractServerIDFromEPR(memberEpr)) == null) continue;
                this.cachedIdentities.put(container, dn);
                return dn;
            }
        }
        catch (Exception e) {
            throw new IOException("Problem when searching in registry for container DN", e);
        }
        throw new IOException("DN of the container not found in Registry");
    }
}

