/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.orchestrator.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrchestratorServerThreadPoolExecutor {
    private static final Logger logger = LoggerFactory.getLogger(OrchestratorServerThreadPoolExecutor.class);
    public static final String AIRAVATA_SERVER_THREAD_POOL_SIZE = "airavata.server.thread.pool.size";
    private static ExecutorService threadPool;

    public static ExecutorService getCachedThreadPool() {
        if (threadPool == null) {
            threadPool = Executors.newCachedThreadPool();
        }
        return threadPool;
    }

    public static ExecutorService getFixedThreadPool() {
        if (threadPool == null) {
            try {
                threadPool = Executors.newFixedThreadPool(Integer.parseInt(ServerSettings.getSetting((String)AIRAVATA_SERVER_THREAD_POOL_SIZE)));
            }
            catch (ApplicationSettingsException e) {
                logger.error("Error reading airavata.server.thread.pool.size property");
            }
        }
        return threadPool;
    }
}

