/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition;

import com.hazelcast.nio.Address;
import com.hazelcast.partition.PartitionListener;
import com.hazelcast.partition.PartitionReplicaChangeEvent;
import com.hazelcast.partition.PartitionView;
import java.util.concurrent.atomic.AtomicReferenceArray;

final class PartitionImpl
implements PartitionView {
    private final int partitionId;
    private final AtomicReferenceArray<Address> addresses = new AtomicReferenceArray(7);
    private final PartitionListener partitionListener;

    PartitionImpl(int partitionId, PartitionListener partitionListener) {
        this.partitionId = partitionId;
        this.partitionListener = partitionListener;
    }

    PartitionImpl(int partitionId) {
        this(partitionId, null);
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public Address getOwner() {
        return this.addresses.get(0);
    }

    void setOwner(Address ownerAddress) {
        this.setReplicaAddress(0, ownerAddress);
    }

    @Override
    public Address getReplicaAddress(int index) {
        return this.addresses.length() > index ? this.addresses.get(index) : null;
    }

    void setReplicaAddress(int index, Address address) {
        boolean changed = false;
        Address currentAddress = this.addresses.get(index);
        if (this.partitionListener != null) {
            changed = currentAddress == null ? address != null : !currentAddress.equals(address);
        }
        this.addresses.set(index, address);
        if (changed) {
            this.partitionListener.replicaChanged(new PartitionReplicaChangeEvent(this.partitionId, index, currentAddress, address));
        }
    }

    boolean onDeadAddress(Address deadAddress) {
        for (int i = 0; i < 7; ++i) {
            if (!deadAddress.equals(this.addresses.get(i))) continue;
            int a = i;
            while (a + 1 < 7) {
                this.setReplicaAddress(a, this.addresses.get(a + 1));
                ++a;
            }
            this.setReplicaAddress(6, null);
            return true;
        }
        return false;
    }

    void setPartitionInfo(PartitionView partition) {
        for (int i = 0; i < 7; ++i) {
            this.setReplicaAddress(i, partition.getReplicaAddress(i));
        }
    }

    @Override
    public boolean isBackup(Address address) {
        for (int i = 1; i < 7; ++i) {
            if (!address.equals(this.getReplicaAddress(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOwnerOrBackup(Address address) {
        for (int i = 0; i < 7; ++i) {
            if (!address.equals(this.getReplicaAddress(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getReplicaIndexOf(Address address) {
        for (int i = 0; i < 7; ++i) {
            if (!address.equals(this.addresses.get(i))) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionImpl that = (PartitionImpl)o;
        if (this.partitionId != that.partitionId) {
            return false;
        }
        for (int i = 0; i < 7; ++i) {
            Address a1 = this.addresses.get(i);
            Address a2 = that.addresses.get(i);
            if (!(a1 == null ? a2 != null : !a1.equals(a2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.partitionId;
        for (int i = 0; i < 7; ++i) {
            Address address = this.addresses.get(i);
            result = 31 * result + (address != null ? address.hashCode() : 0);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Partition [").append(this.partitionId).append("]{\n");
        for (int i = 0; i < 7; ++i) {
            Address address = this.addresses.get(i);
            if (address == null) continue;
            sb.append('\t');
            sb.append(i).append(":").append(address);
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }
}

