/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.entities;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.EntityManagerFactoryImpl;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.compass.core.mapping.ResourceMapping;
import org.compass.gps.device.jpa.JpaGpsDevice;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.entities.EntityInformation;
import org.compass.gps.device.jpa.entities.JpaEntitiesLocator;
import org.compass.gps.spi.CompassGpsInterfaceDevice;

public class OpenJPAJpaEntitiesLocator
implements JpaEntitiesLocator {
    protected Log log = LogFactory.getLog(this.getClass());
    private ClassLoader classLoader;

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public EntityInformation[] locate(EntityManagerFactory entityManagerFactory, JpaGpsDevice device) throws JpaGpsDeviceException {
        CompassGpsInterfaceDevice gps = (CompassGpsInterfaceDevice)device.getGps();
        EntityManagerFactoryImpl emf = (EntityManagerFactoryImpl)OpenJPAPersistence.cast((EntityManagerFactory)entityManagerFactory);
        ArrayList<EntityInformation> entitiesList = new ArrayList<EntityInformation>();
        OpenJPAEntityManagerSPI entityManager = emf.createEntityManager();
        entityManager.close();
        Collection classes = emf.getConfiguration().getMetaDataRepositoryInstance().loadPersistentTypes(true, this.classLoader);
        for (Class clazz : classes) {
            ClassMetaData classMetaData = emf.getConfiguration().getMetaDataRepositoryInstance().getMetaData(clazz, this.classLoader, true);
            String entityname = classMetaData.getDescribedType().getName();
            if (!gps.hasMappingForEntityForIndex(entityname)) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Entity [" + entityname + "] does not have compass mapping, filtering it out"));
                continue;
            }
            if (this.shouldFilter(entityname, classMetaData, device)) continue;
            ResourceMapping resourceMapping = gps.getMappingForEntityForIndex(entityname);
            EntityInformation entityInformation = new EntityInformation(clazz, entityname, resourceMapping.getSubIndexHash().getSubIndexes());
            entitiesList.add(entityInformation);
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Entity [" + entityname + "] will be indexed"));
        }
        return entitiesList.toArray(new EntityInformation[entitiesList.size()]);
    }

    protected boolean shouldFilter(String entityname, ClassMetaData classMetadata, JpaGpsDevice device) {
        Class superClass;
        Class clazz = classMetadata.getDescribedType();
        if (classMetadata.getMappedPCSuperclassMetaData() != null && (superClass = classMetadata.getMappedPCSuperclassMetaData().getDescribedType()) != null && ((CompassGpsInterfaceDevice)device.getGps()).hasMappingForEntityForIndex(superClass)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Entity [" + entityname + "] is inherited and super class [" + superClass + "] has compass mapping, filtering it out"));
            }
            return true;
        }
        return false;
    }
}

