/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.airavata.cloud.aurora.client.sdk;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.server.AbstractNonblockingServer.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings({"cast", "rawtypes", "serial", "unchecked"})
/**
 * A volume mount point within a container
 */
@Generated(value = "Autogenerated by Thrift Compiler (0.9.3)", date = "2016-10-21")
public class Volume implements org.apache.thrift.TBase<Volume, Volume._Fields>, java.io.Serializable, Cloneable, Comparable<Volume> {
  private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("Volume");

  private static final org.apache.thrift.protocol.TField CONTAINER_PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("containerPath", org.apache.thrift.protocol.TType.STRING, (short)1);
  private static final org.apache.thrift.protocol.TField HOST_PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("hostPath", org.apache.thrift.protocol.TType.STRING, (short)2);
  private static final org.apache.thrift.protocol.TField MODE_FIELD_DESC = new org.apache.thrift.protocol.TField("mode", org.apache.thrift.protocol.TType.I32, (short)3);

  private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
  static {
    schemes.put(StandardScheme.class, new VolumeStandardSchemeFactory());
    schemes.put(TupleScheme.class, new VolumeTupleSchemeFactory());
  }

  /**
   * The path inside the container where the mount will be created.
   */
  public String containerPath; // required
  /**
   * The path on the host that will serve as the source for the mount.
   */
  public String hostPath; // required
  /**
   * The access mode
   * 
   * @see Mode
   */
  public Mode mode; // required

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements org.apache.thrift.TFieldIdEnum {
    /**
     * The path inside the container where the mount will be created.
     */
    CONTAINER_PATH((short)1, "containerPath"),
    /**
     * The path on the host that will serve as the source for the mount.
     */
    HOST_PATH((short)2, "hostPath"),
    /**
     * The access mode
     * 
     * @see Mode
     */
    MODE((short)3, "mode");

    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }

    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case 1: // CONTAINER_PATH
          return CONTAINER_PATH;
        case 2: // HOST_PATH
          return HOST_PATH;
        case 3: // MODE
          return MODE;
        default:
          return null;
      }
    }

    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }

    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }

    private final short _thriftId;
    private final String _fieldName;

    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }

    public short getThriftFieldId() {
      return _thriftId;
    }

    public String getFieldName() {
      return _fieldName;
    }
  }

  // isset id assignments
  public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
  static {
    Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.CONTAINER_PATH, new org.apache.thrift.meta_data.FieldMetaData("containerPath", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.HOST_PATH, new org.apache.thrift.meta_data.FieldMetaData("hostPath", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.MODE, new org.apache.thrift.meta_data.FieldMetaData("mode", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, Mode.class)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(Volume.class, metaDataMap);
  }

  public Volume() {
  }

  public Volume(
    String containerPath,
    String hostPath,
    Mode mode)
  {
    this();
    this.containerPath = containerPath;
    this.hostPath = hostPath;
    this.mode = mode;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public Volume(Volume other) {
    if (other.isSetContainerPath()) {
      this.containerPath = other.containerPath;
    }
    if (other.isSetHostPath()) {
      this.hostPath = other.hostPath;
    }
    if (other.isSetMode()) {
      this.mode = other.mode;
    }
  }

  public Volume deepCopy() {
    return new Volume(this);
  }

  @Override
  public void clear() {
    this.containerPath = null;
    this.hostPath = null;
    this.mode = null;
  }

  /**
   * The path inside the container where the mount will be created.
   */
  public String getContainerPath() {
    return this.containerPath;
  }

  /**
   * The path inside the container where the mount will be created.
   */
  public Volume setContainerPath(String containerPath) {
    this.containerPath = containerPath;
    return this;
  }

  public void unsetContainerPath() {
    this.containerPath = null;
  }

  /** Returns true if field containerPath is set (has been assigned a value) and false otherwise */
  public boolean isSetContainerPath() {
    return this.containerPath != null;
  }

  public void setContainerPathIsSet(boolean value) {
    if (!value) {
      this.containerPath = null;
    }
  }

  /**
   * The path on the host that will serve as the source for the mount.
   */
  public String getHostPath() {
    return this.hostPath;
  }

  /**
   * The path on the host that will serve as the source for the mount.
   */
  public Volume setHostPath(String hostPath) {
    this.hostPath = hostPath;
    return this;
  }

  public void unsetHostPath() {
    this.hostPath = null;
  }

  /** Returns true if field hostPath is set (has been assigned a value) and false otherwise */
  public boolean isSetHostPath() {
    return this.hostPath != null;
  }

  public void setHostPathIsSet(boolean value) {
    if (!value) {
      this.hostPath = null;
    }
  }

  /**
   * The access mode
   * 
   * @see Mode
   */
  public Mode getMode() {
    return this.mode;
  }

  /**
   * The access mode
   * 
   * @see Mode
   */
  public Volume setMode(Mode mode) {
    this.mode = mode;
    return this;
  }

  public void unsetMode() {
    this.mode = null;
  }

  /** Returns true if field mode is set (has been assigned a value) and false otherwise */
  public boolean isSetMode() {
    return this.mode != null;
  }

  public void setModeIsSet(boolean value) {
    if (!value) {
      this.mode = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case CONTAINER_PATH:
      if (value == null) {
        unsetContainerPath();
      } else {
        setContainerPath((String)value);
      }
      break;

    case HOST_PATH:
      if (value == null) {
        unsetHostPath();
      } else {
        setHostPath((String)value);
      }
      break;

    case MODE:
      if (value == null) {
        unsetMode();
      } else {
        setMode((Mode)value);
      }
      break;

    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case CONTAINER_PATH:
      return getContainerPath();

    case HOST_PATH:
      return getHostPath();

    case MODE:
      return getMode();

    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case CONTAINER_PATH:
      return isSetContainerPath();
    case HOST_PATH:
      return isSetHostPath();
    case MODE:
      return isSetMode();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof Volume)
      return this.equals((Volume)that);
    return false;
  }

  public boolean equals(Volume that) {
    if (that == null)
      return false;

    boolean this_present_containerPath = true && this.isSetContainerPath();
    boolean that_present_containerPath = true && that.isSetContainerPath();
    if (this_present_containerPath || that_present_containerPath) {
      if (!(this_present_containerPath && that_present_containerPath))
        return false;
      if (!this.containerPath.equals(that.containerPath))
        return false;
    }

    boolean this_present_hostPath = true && this.isSetHostPath();
    boolean that_present_hostPath = true && that.isSetHostPath();
    if (this_present_hostPath || that_present_hostPath) {
      if (!(this_present_hostPath && that_present_hostPath))
        return false;
      if (!this.hostPath.equals(that.hostPath))
        return false;
    }

    boolean this_present_mode = true && this.isSetMode();
    boolean that_present_mode = true && that.isSetMode();
    if (this_present_mode || that_present_mode) {
      if (!(this_present_mode && that_present_mode))
        return false;
      if (!this.mode.equals(that.mode))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    List<Object> list = new ArrayList<Object>();

    boolean present_containerPath = true && (isSetContainerPath());
    list.add(present_containerPath);
    if (present_containerPath)
      list.add(containerPath);

    boolean present_hostPath = true && (isSetHostPath());
    list.add(present_hostPath);
    if (present_hostPath)
      list.add(hostPath);

    boolean present_mode = true && (isSetMode());
    list.add(present_mode);
    if (present_mode)
      list.add(mode.getValue());

    return list.hashCode();
  }

  @Override
  public int compareTo(Volume other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;

    lastComparison = Boolean.valueOf(isSetContainerPath()).compareTo(other.isSetContainerPath());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetContainerPath()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.containerPath, other.containerPath);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetHostPath()).compareTo(other.isSetHostPath());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetHostPath()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.hostPath, other.hostPath);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetMode()).compareTo(other.isSetMode());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetMode()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.mode, other.mode);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }

  public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
    schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
  }

  public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
    schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("Volume(");
    boolean first = true;

    sb.append("containerPath:");
    if (this.containerPath == null) {
      sb.append("null");
    } else {
      sb.append(this.containerPath);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("hostPath:");
    if (this.hostPath == null) {
      sb.append("null");
    } else {
      sb.append(this.hostPath);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("mode:");
    if (this.mode == null) {
      sb.append("null");
    } else {
      sb.append(this.mode);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws org.apache.thrift.TException {
    // check for required fields
    // check for sub-struct validity
  }

  private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
    try {
      write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
    } catch (org.apache.thrift.TException te) {
      throw new java.io.IOException(te);
    }
  }

  private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
    try {
      read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
    } catch (org.apache.thrift.TException te) {
      throw new java.io.IOException(te);
    }
  }

  private static class VolumeStandardSchemeFactory implements SchemeFactory {
    public VolumeStandardScheme getScheme() {
      return new VolumeStandardScheme();
    }
  }

  private static class VolumeStandardScheme extends StandardScheme<Volume> {

    public void read(org.apache.thrift.protocol.TProtocol iprot, Volume struct) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField schemeField;
      iprot.readStructBegin();
      while (true)
      {
        schemeField = iprot.readFieldBegin();
        if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (schemeField.id) {
          case 1: // CONTAINER_PATH
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.containerPath = iprot.readString();
              struct.setContainerPathIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 2: // HOST_PATH
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.hostPath = iprot.readString();
              struct.setHostPathIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 3: // MODE
            if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
              struct.mode = org.apache.airavata.cloud.aurora.client.sdk.Mode.findByValue(iprot.readI32());
              struct.setModeIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      struct.validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot, Volume struct) throws org.apache.thrift.TException {
      struct.validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (struct.containerPath != null) {
        oprot.writeFieldBegin(CONTAINER_PATH_FIELD_DESC);
        oprot.writeString(struct.containerPath);
        oprot.writeFieldEnd();
      }
      if (struct.hostPath != null) {
        oprot.writeFieldBegin(HOST_PATH_FIELD_DESC);
        oprot.writeString(struct.hostPath);
        oprot.writeFieldEnd();
      }
      if (struct.mode != null) {
        oprot.writeFieldBegin(MODE_FIELD_DESC);
        oprot.writeI32(struct.mode.getValue());
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

  }

  private static class VolumeTupleSchemeFactory implements SchemeFactory {
    public VolumeTupleScheme getScheme() {
      return new VolumeTupleScheme();
    }
  }

  private static class VolumeTupleScheme extends TupleScheme<Volume> {

    @Override
    public void write(org.apache.thrift.protocol.TProtocol prot, Volume struct) throws org.apache.thrift.TException {
      TTupleProtocol oprot = (TTupleProtocol) prot;
      BitSet optionals = new BitSet();
      if (struct.isSetContainerPath()) {
        optionals.set(0);
      }
      if (struct.isSetHostPath()) {
        optionals.set(1);
      }
      if (struct.isSetMode()) {
        optionals.set(2);
      }
      oprot.writeBitSet(optionals, 3);
      if (struct.isSetContainerPath()) {
        oprot.writeString(struct.containerPath);
      }
      if (struct.isSetHostPath()) {
        oprot.writeString(struct.hostPath);
      }
      if (struct.isSetMode()) {
        oprot.writeI32(struct.mode.getValue());
      }
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol prot, Volume struct) throws org.apache.thrift.TException {
      TTupleProtocol iprot = (TTupleProtocol) prot;
      BitSet incoming = iprot.readBitSet(3);
      if (incoming.get(0)) {
        struct.containerPath = iprot.readString();
        struct.setContainerPathIsSet(true);
      }
      if (incoming.get(1)) {
        struct.hostPath = iprot.readString();
        struct.setHostPathIsSet(true);
      }
      if (incoming.get(2)) {
        struct.mode = org.apache.airavata.cloud.aurora.client.sdk.Mode.findByValue(iprot.readI32());
        struct.setModeIsSet(true);
      }
    }
  }

}

