/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderSupport;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.spi.RouteContext;

public class NoErrorHandlerBuilder
extends ErrorHandlerBuilderSupport {
    @Override
    public Processor createErrorHandler(RouteContext routeContext, Processor processor) {
        return new DelegateAsyncProcessor(processor){

            @Override
            public boolean process(final Exchange exchange, final AsyncCallback callback) {
                return super.process(exchange, new AsyncCallback(){

                    @Override
                    public void done(boolean doneSync) {
                        exchange.removeProperty("CamelRedeliveryExhausted");
                        callback.done(doneSync);
                    }
                });
            }

            @Override
            public String toString() {
                if (this.processor == null) {
                    return "";
                }
                return "NoErrorHandler[" + this.processor + "]";
            }
        };
    }

    @Override
    public boolean supportTransacted() {
        return false;
    }

    @Override
    public ErrorHandlerBuilder cloneBuilder() {
        NoErrorHandlerBuilder answer = new NoErrorHandlerBuilder();
        this.cloneBuilder(answer);
        return answer;
    }
}

