/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet.mmd2;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.musicbrainz.mmd2.Alias;
import org.musicbrainz.mmd2.Instrument;
import org.musicbrainz.mmd2.InstrumentList;
import org.musicbrainz.mmd2.Metadata;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.InstrumentIndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.servlet.Result;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.mmd2.ResultsWriter;

public class InstrumentWriter
extends ResultsWriter {
    public void write(Metadata metadata, Results results) throws IOException {
        ObjectFactory of = new ObjectFactory();
        InstrumentList instrumentList = of.createInstrumentList();
        for (Result result : results.results) {
            result.setNormalizedScore(results.getMaxScore());
        }
        this.write(instrumentList.getInstrument(), results);
        instrumentList.setCount(BigInteger.valueOf(results.getTotalHits()));
        instrumentList.setOffset(BigInteger.valueOf(results.getOffset()));
        metadata.setInstrumentList(instrumentList);
    }

    public void write(List list, Results results) throws IOException {
        for (Result result : results.results) {
            this.write(list, result);
        }
    }

    public void write(List list, Result result) throws IOException {
        MbDocument doc = result.getDoc();
        Instrument instrument = (Instrument)MMDSerializer.unserialize((String)doc.get((IndexField)InstrumentIndexField.INSTRUMENT_STORE), Instrument.class);
        instrument.setScore(Integer.valueOf(result.getNormalizedScore()));
        list.add(instrument);
    }

    public void adjustForJson(Metadata metadata) {
        if (metadata.getInstrumentList().getInstrument().size() > 0) {
            for (Instrument instrument : metadata.getInstrumentList().getInstrument()) {
                if (instrument.getAliasList() == null) continue;
                for (Alias alias : instrument.getAliasList().getAlias()) {
                    if (alias.getPrimary() == null) {
                        alias.setPrimary("false");
                        continue;
                    }
                    alias.setPrimary("true");
                }
            }
        }
    }
}

