/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.similarities.Similarity;
import org.musicbrainz.search.servlet.ResourceType;

public class MusicBrainzSearcherFactory
extends SearcherFactory {
    private final ResourceType resourceType;

    public MusicBrainzSearcherFactory(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public IndexSearcher newSearcher(IndexReader reader) throws IOException {
        IndexSearcher searcher = super.newSearcher(reader);
        if (this.resourceType.getSimilarityClass() != null) {
            try {
                Similarity similarity = (Similarity)this.resourceType.getSimilarityClass().newInstance();
                searcher.setSimilarity(similarity);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return searcher;
    }
}

