/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet.mmd1;

import com.google.common.base.Strings;
import com.jthink.brainz.mmd.Artist;
import com.jthink.brainz.mmd.DiscList;
import com.jthink.brainz.mmd.Event;
import com.jthink.brainz.mmd.Metadata;
import com.jthink.brainz.mmd.ObjectFactory;
import com.jthink.brainz.mmd.ReleaseEventList;
import com.jthink.brainz.mmd.ReleaseList;
import com.jthink.brainz.mmd.TextRepresentation;
import com.jthink.brainz.mmd.TrackList;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.musicbrainz.mmd2.ArtistCredit;
import org.musicbrainz.mmd2.Label;
import org.musicbrainz.mmd2.LabelInfo;
import org.musicbrainz.mmd2.LabelInfoList;
import org.musicbrainz.mmd2.Medium;
import org.musicbrainz.mmd2.MediumList;
import org.musicbrainz.mmd2.NameCredit;
import org.musicbrainz.mmd2.Release;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.index.ReleaseIndexField;
import org.musicbrainz.search.servlet.Result;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.mmd1.Mmd1XmlWriter;

public class ReleaseMmd1XmlWriter
extends Mmd1XmlWriter {
    public Metadata write(Results results) throws IOException {
        ObjectFactory of = new ObjectFactory();
        Metadata metadata = of.createMetadata();
        ReleaseList releaseList = of.createReleaseList();
        for (Result result : results.results) {
            ReleaseEventList eventList;
            MbDocument doc = result.getDoc();
            com.jthink.brainz.mmd.Release release = of.createRelease();
            result.setNormalizedScore(results.getMaxScore());
            release.getOtherAttributes().put(this.getScore(), String.valueOf(result.getNormalizedScore()));
            Release releasev2 = (Release)MMDSerializer.unserialize((String)doc.get((IndexField)ReleaseIndexField.RELEASE_STORE), Release.class);
            release.setId(releasev2.getId());
            release.getType().add(StringUtils.capitalize((String)releasev2.getReleaseGroup().getType()));
            if (!Strings.isNullOrEmpty((String)releasev2.getStatus())) {
                release.getType().add(releasev2.getStatus());
            }
            if (!Strings.isNullOrEmpty((String)releasev2.getTitle())) {
                release.setTitle(releasev2.getTitle());
            }
            if (!Strings.isNullOrEmpty((String)releasev2.getAsin())) {
                release.setAsin(releasev2.getAsin());
            }
            TextRepresentation tr = of.createTextRepresentation();
            org.musicbrainz.mmd2.TextRepresentation tr2 = releasev2.getTextRepresentation();
            if (tr2 != null) {
                if (!Strings.isNullOrEmpty((String)tr2.getScript())) {
                    tr.setScript(tr2.getScript());
                }
                if (!Strings.isNullOrEmpty((String)tr2.getLanguage())) {
                    tr.setLanguage(tr2.getLanguage().toUpperCase(Locale.US));
                }
                release.setTextRepresentation(tr);
            }
            if (!Strings.isNullOrEmpty((String)releasev2.getCountry())) {
                release.setAsin(releasev2.getAsin());
            }
            if (!Strings.isNullOrEmpty((String)releasev2.getDate())) {
                release.setAsin(releasev2.getAsin());
            }
            if (!Strings.isNullOrEmpty((String)releasev2.getBarcode())) {
                release.setAsin(releasev2.getAsin());
            }
            if (!Strings.isNullOrEmpty((String)releasev2.getAsin())) {
                release.setAsin(releasev2.getAsin());
            }
            Medium firstMediumv2 = (Medium)releasev2.getMediumList().getMedium().get(0);
            LabelInfoList lilv2 = releasev2.getLabelInfoList();
            if (lilv2 != null && !lilv2.getLabelInfo().isEmpty()) {
                eventList = of.createReleaseEventList();
                for (LabelInfo liv2 : lilv2.getLabelInfo()) {
                    Label labelv2;
                    Event event = of.createEvent();
                    if (!Strings.isNullOrEmpty((String)liv2.getCatalogNumber())) {
                        event.setCatalogNumber(liv2.getCatalogNumber());
                    }
                    if ((labelv2 = liv2.getLabel()) != null) {
                        com.jthink.brainz.mmd.Label label = of.createLabel();
                        event.setLabel(label);
                        if (!Strings.isNullOrEmpty((String)labelv2.getId())) {
                            label.setId(labelv2.getId());
                        }
                        if (!Strings.isNullOrEmpty((String)labelv2.getName())) {
                            label.setName(labelv2.getName());
                        }
                    }
                    if (!Strings.isNullOrEmpty((String)releasev2.getCountry())) {
                        event.setCountry(StringUtils.upperCase((String)releasev2.getCountry()));
                    }
                    if (!Strings.isNullOrEmpty((String)releasev2.getDate())) {
                        event.setDate(releasev2.getDate());
                    }
                    if (!Strings.isNullOrEmpty((String)releasev2.getBarcode())) {
                        event.setBarcode(releasev2.getBarcode());
                    }
                    if (!Strings.isNullOrEmpty((String)firstMediumv2.getFormat())) {
                        event.setFormat(firstMediumv2.getFormat());
                    }
                    eventList.getEvent().add(event);
                }
                release.setReleaseEventList(eventList);
            } else {
                eventList = of.createReleaseEventList();
                Event event = of.createEvent();
                eventList.getEvent().add(event);
                release.setReleaseEventList(eventList);
                if (!Strings.isNullOrEmpty((String)releasev2.getCountry())) {
                    event.setCountry(StringUtils.upperCase((String)releasev2.getCountry()));
                }
                if (!Strings.isNullOrEmpty((String)releasev2.getDate())) {
                    event.setDate(releasev2.getDate());
                }
                if (!Strings.isNullOrEmpty((String)releasev2.getBarcode())) {
                    event.setBarcode(releasev2.getBarcode());
                }
                if (!Strings.isNullOrEmpty((String)firstMediumv2.getFormat())) {
                    event.setFormat(firstMediumv2.getFormat());
                }
            }
            ArtistCredit acv2 = releasev2.getArtistCredit();
            if (acv2 != null && acv2.getNameCredit().size() > 0) {
                Artist artist = of.createArtist();
                artist.setName(((NameCredit)acv2.getNameCredit().get(0)).getArtist().getName());
                artist.setId(((NameCredit)acv2.getNameCredit().get(0)).getArtist().getId());
                artist.setSortName(((NameCredit)acv2.getNameCredit().get(0)).getArtist().getSortName());
                release.setArtist(artist);
            }
            int totaldiscIds = 0;
            MediumList mediumListv2 = releasev2.getMediumList();
            TrackList trackList = of.createTrackList();
            trackList.setCount(mediumListv2.getTrackCount());
            release.setTrackList(trackList);
            for (Medium mediumv2 : mediumListv2.getMedium()) {
                totaldiscIds += mediumv2.getDiscList().getCount().intValue();
            }
            DiscList discList = of.createDiscList();
            discList.setCount(BigInteger.valueOf(totaldiscIds));
            release.setDiscList(discList);
            releaseList.getRelease().add(release);
        }
        releaseList.setCount(BigInteger.valueOf(results.getTotalHits()));
        releaseList.setOffset(BigInteger.valueOf(results.getOffset()));
        metadata.setReleaseList(releaseList);
        return metadata;
    }
}

