/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Query;
import org.musicbrainz.search.servlet.DismaxAlias;
import org.musicbrainz.search.servlet.DismaxQueryParser;

public class DismaxQueryParser {
    public static String IMPOSSIBLE_FIELD_NAME = "\ufffc\ufffc\ufffc";
    protected DisjunctionQueryParser dqp;

    protected DismaxQueryParser() {
    }

    public DismaxQueryParser(Analyzer analyzer) {
        this.dqp = new DisjunctionQueryParser(IMPOSSIBLE_FIELD_NAME, analyzer);
    }

    public Query parse(String query) throws ParseException {
        Query term = this.dqp.parse(IMPOSSIBLE_FIELD_NAME + ":(" + query + ")");
        Query phrase = this.dqp.parse(IMPOSSIBLE_FIELD_NAME + ":\"" + query + "\"");
        return this.buildTopQuery(term, phrase);
    }

    protected Query buildTopQuery(Query term, Query phrase) {
        if (phrase instanceof DisjunctionMaxQuery) {
            BooleanQuery bq = new BooleanQuery(true);
            bq.add(term, BooleanClause.Occur.MUST);
            bq.add(phrase, BooleanClause.Occur.SHOULD);
            return bq;
        }
        return term;
    }

    public void addAlias(String field, DismaxAlias dismaxAlias) {
        this.dqp.addAlias(field, dismaxAlias);
    }
}

