/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import com.google.common.base.Strings;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.similarities.Similarity;
import org.musicbrainz.mmd2.Alias;
import org.musicbrainz.mmd2.Instrument;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.mmd2.Tag;
import org.musicbrainz.mmd2.TagList;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.analysis.MusicbrainzSimilarity;
import org.musicbrainz.search.helper.AliasHelper;
import org.musicbrainz.search.helper.TagHelper;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.InstrumentIndexField;
import org.musicbrainz.search.index.MMDSerializer;

public class InstrumentIndex
extends DatabaseIndex {
    public static final String INDEX_NAME = "instrument";

    public InstrumentIndex(Connection dbConnection) {
        super(dbConnection);
    }

    public InstrumentIndex() {
    }

    @Override
    public String getName() {
        return INDEX_NAME;
    }

    @Override
    public Analyzer getAnalyzer() {
        return DatabaseIndex.getAnalyzer(InstrumentIndexField.class);
    }

    @Override
    public IndexField getIdentifierField() {
        return InstrumentIndexField.ID;
    }

    @Override
    public int getMaxId() throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT MAX(id) FROM instrument");
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public int getNoOfRows(int maxId) throws SQLException {
        PreparedStatement st = this.dbConnection.prepareStatement("SELECT count(*) FROM instrument WHERE id <= ?");
        st.setInt(1, maxId);
        ResultSet rs = st.executeQuery();
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public Similarity getSimilarity() {
        return new MusicbrainzSimilarity();
    }

    @Override
    public void init(IndexWriter indexWriter, boolean isUpdater) throws SQLException {
        this.addPreparedStatement("INSTRUMENTS", "SELECT instrument.id, instrument.gid, instrument.name as name,  instrument_type.name as type,   instrument.comment,    instrument.description  FROM instrument   LEFT JOIN instrument_type ON instrument.type = instrument_type.id  WHERE instrument.id BETWEEN ? AND ?");
        this.addPreparedStatement("TAGS", TagHelper.constructTagQuery("instrument_tag", INDEX_NAME));
        this.addPreparedStatement("ALIASES", AliasHelper.constructAliasQuery(INDEX_NAME));
    }

    @Override
    public void indexData(IndexWriter indexWriter, int min, int max) throws SQLException, IOException {
        ObjectFactory of = new ObjectFactory();
        Map<Integer, Set<Alias>> aliases = AliasHelper.completeFromDbResults(min, max, this.getPreparedStatement("ALIASES"));
        Map<Integer, List<Tag>> tags = TagHelper.loadTags(min, max, this.getPreparedStatement("TAGS"), INDEX_NAME);
        PreparedStatement st = this.getPreparedStatement("INSTRUMENTS");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            indexWriter.addDocument(this.documentFromResultSet(rs, tags, aliases));
        }
        rs.close();
    }

    public Document documentFromResultSet(ResultSet rs, Map<Integer, List<Tag>> tags, Map<Integer, Set<Alias>> aliases) throws SQLException {
        MbDocument doc = new MbDocument();
        ObjectFactory of = new ObjectFactory();
        Instrument instrument = of.createInstrument();
        int instrumentId = rs.getInt("id");
        doc.addField((IndexField)InstrumentIndexField.ID, instrumentId);
        String instrumentGuid = rs.getString("gid");
        doc.addField((IndexField)InstrumentIndexField.INSTRUMENT_ID, instrumentGuid);
        instrument.setId(instrumentGuid);
        String name = rs.getString("name");
        doc.addField((IndexField)InstrumentIndexField.INSTRUMENT, name);
        instrument.setName(name);
        String type = rs.getString("type");
        doc.addFieldOrUnknown(InstrumentIndexField.TYPE, type);
        if (!Strings.isNullOrEmpty(type)) {
            instrument.setType(type);
        }
        String comment = rs.getString("comment");
        doc.addFieldOrNoValue(InstrumentIndexField.COMMENT, comment);
        if (!Strings.isNullOrEmpty(comment)) {
            instrument.setDisambiguation(comment);
        }
        String description = rs.getString("description");
        doc.addFieldOrNoValue(InstrumentIndexField.DESCRIPTION, description);
        if (!Strings.isNullOrEmpty(description)) {
            instrument.setDescription(description);
        }
        if (aliases.containsKey(instrumentId)) {
            instrument.setAliasList(AliasHelper.addAliasesToDocAndConstructAliasList(of, doc, aliases, instrumentId, InstrumentIndexField.ALIAS));
        }
        if (tags.containsKey(instrumentId)) {
            TagList tagList = TagHelper.addTagsToDocAndConstructTagList(of, doc, tags, instrumentId, InstrumentIndexField.TAG);
            instrument.setTagList(tagList);
        }
        String store = MMDSerializer.serialize(instrument);
        doc.addField((IndexField)InstrumentIndexField.INSTRUMENT_STORE, store);
        return doc.getLuceneDocument();
    }
}

