/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: ParameterUploadAspect.java,v $
 * Version:       $Name:  $ $Revision: 1.4 $
 * Last Modified: $Date: 2006/08/22 15:52:54 $
 *****************************************************************************/
package org.ten60.transport.http.parameter.representation;

import org.ten60.transport.http.util.*;
import javax.servlet.http.Cookie;
import com.ten60.netkernel.urii.*;

import org.ten60.netkernel.layer1.representation.*;
import com.ten60.netkernel.urii.aspect.*;

import org.ten60.netkernel.layer1.util.Utils;

import java.io.*;


/**
 *
 * @author  pjr
 */
public class ParameterUploadAspect implements IAspectReadableBinaryStream, IURAspect
{
	private MultiPartRequest mRequest;
	private String mName;
	private String mFilename;
	
	/** Creates a new instance of ParameterNVPProxy */
	private ParameterUploadAspect(MultiPartRequest aRequest, String aName, String aFilename)
	{	mRequest=aRequest;
		mName=aName;
		mFilename=aFilename;
	}
	
	public static IURRepresentation create(IURMeta aMeta, MultiPartRequest aRequest, String aName, String aFilename)
	{	return new MonoRepresentationImpl(aMeta, new ParameterUploadAspect(aRequest, aName, aFilename));
	}
	
	public String getFilename()
	{	return mFilename;
	}
	
	public String getEncoding()
	{	return "UTF-8";
	}
	
	public void write(java.io.OutputStream aStream) throws java.io.IOException
	{	InputStream is = mRequest.getInputStream(mName);
		Utils.pipe(is, aStream);
	}
	
	public int getContentLength()
	{	return mRequest.getContentLength(mName);
	}
	
	public InputStream getInputStream() throws IOException
	{	return mRequest.getInputStream(mName);
	}
	
}
