/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseLocalMessages;
import com.microsoft.util.UtilLocalMessages;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.MissingResourceException;

class BaseMessages {
    private static final String footprint = "$Revision:   1.8  $";
    private static BaseLocalMessages baseLocalMessages = new BaseLocalMessages();
    private UtilLocalMessages implLocalMessages;
    private String driverName;

    public BaseMessages(String string) throws SQLException {
        this.driverName = string;
        this.loadImplLocalMessages();
    }

    protected String formatMessage(String string, String[] stringArray, boolean bl) {
        String string2 = "[Microsoft][" + this.driverName + " 2000 Driver for JDBC]";
        if (bl) {
            string2 = String.valueOf(string2) + "[" + this.driverName + "]";
        }
        string2 = String.valueOf(string2) + string;
        if (stringArray != null) {
            string2 = MessageFormat.format(string2, stringArray);
        }
        return string2;
    }

    public String getMessage(int n, String[] stringArray, boolean bl) {
        String string;
        block5: {
            string = null;
            if (this.implLocalMessages != null) {
                try {
                    string = this.implLocalMessages.getString(n, stringArray);
                }
                catch (MissingResourceException missingResourceException) {}
            }
            if (string != null) break block5;
            try {
                string = baseLocalMessages.getString(n, stringArray);
            }
            catch (MissingResourceException missingResourceException) {
                string = "(Internal Error) Message not found.";
                stringArray = null;
            }
        }
        return this.formatMessage(string, stringArray, bl);
    }

    private void loadImplLocalMessages() throws SQLException {
        String string = "com.microsoft.jdbc." + this.driverName.toLowerCase() + "." + this.driverName + "LocalMessages";
        try {
            this.implLocalMessages = (UtilLocalMessages)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }
}

